/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.listeners;

import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.plugins.kb.internal.listeners.KBCommentEventListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KBCommentShareChecker {
    private static final Logger log = LoggerFactory.getLogger(KBCommentEventListener.class);
    private static final Pattern KB_URL_PATTERN = Pattern.compile(".*(?i)https?(?-i)://.+?/servicedesk/customer/kb/view/[\\d]+.*", 32);
    private static final Pattern WIKI_MARKUP_LINK_PATTERN = Pattern.compile("\\[.*?\\|((?i)https?(?-i):\\/\\/.*)\\]", 8);
    private static final Pattern RAW_LINK_PATTERN = Pattern.compile("((?i)https?(?-i):\\/\\/\\S*)", 32);
    private static final String URL_ENCODED = "UTF-8";

    private KBCommentShareChecker() {
    }

    static boolean commentSharesKBLink(ServiceDeskComment sdComment) {
        return sdComment.isPublic() && KBCommentShareChecker.containsKbLink(sdComment.getComment().getBody());
    }

    public static List<Map<String, io.atlassian.fugue.Option<String>>> extractKbArticles(ServiceDeskComment sdComment) {
        String commentBody = sdComment.getComment().getBody();
        List<String> kbLinksInComment = KBCommentShareChecker.getKBLinksInComment(commentBody);
        List<Map<String, io.atlassian.fugue.Option<String>>> kbArticles = KBCommentShareChecker.distinctKbArticlesFromLinks(kbLinksInComment);
        return kbArticles;
    }

    private static List<String> getKBLinksInComment(String commentBody) {
        ArrayList<String> kbLinksInComment = new ArrayList<String>();
        Matcher matcher = WIKI_MARKUP_LINK_PATTERN.matcher(commentBody);
        while (matcher.find()) {
            if (!KBCommentShareChecker.containsKbLink(matcher.group(1))) continue;
            kbLinksInComment.add(matcher.group(1));
            commentBody = commentBody.replaceFirst(Pattern.quote(matcher.group()), "");
        }
        Matcher rawLinkMatcher = RAW_LINK_PATTERN.matcher(commentBody);
        while (rawLinkMatcher.find()) {
            if (!KBCommentShareChecker.containsKbLink(rawLinkMatcher.group(1))) continue;
            kbLinksInComment.add(rawLinkMatcher.group(1));
        }
        return kbLinksInComment;
    }

    private static boolean containsKbLink(String commentOrLink) {
        return KB_URL_PATTERN.matcher(commentOrLink).matches();
    }

    private static List<Map<String, io.atlassian.fugue.Option<String>>> distinctKbArticlesFromLinks(List<String> kbLinks) {
        Stream allArticlesStream = kbLinks.stream().flatMap(KBCommentShareChecker::buildAndFlattenArticle);
        Collection distinctArticles = allArticlesStream.collect(Collectors.toMap(KBCommentShareChecker::getArticleIdentifier, Function.identity(), (articleA, artibleB) -> articleA)).values();
        return Lists.newArrayList(distinctArticles);
    }

    private static Stream<Map<String, io.atlassian.fugue.Option<String>>> buildAndFlattenArticle(String kbLink) {
        return FpKit.toList((Option)StepsConverters.olderOption(KBCommentShareChecker.buildArticleMapFromLink(kbLink))).stream();
    }

    private static String getArticleIdentifier(Map<String, io.atlassian.fugue.Option<String>> article) {
        String pageId = (String)article.get("pageId").get();
        String applicationId = (String)article.get("applicationId").getOrElse((Object)"");
        return String.format("%s %s", pageId, applicationId);
    }

    private static io.atlassian.fugue.Option<Map<String, io.atlassian.fugue.Option<String>>> buildArticleMapFromLink(String kbLink) {
        try {
            HashMap queryParams = Maps.newHashMap();
            List parsedUrl = URLEncodedUtils.parse((URI)new URI(kbLink), (String)URL_ENCODED);
            for (NameValuePair queryParam : parsedUrl) {
                queryParams.put(queryParam.getName(), queryParam.getValue());
            }
            URL kbLinkUrl = new URL(kbLink);
            HashMap<String, io.atlassian.fugue.Option> article = new HashMap<String, io.atlassian.fugue.Option>();
            article.put("url", io.atlassian.fugue.Option.some((Object)kbLink));
            article.put("pageId", io.atlassian.fugue.Option.some((Object)KBCommentShareChecker.getIdFromUrl(kbLinkUrl)));
            article.put("pageTitle", io.atlassian.fugue.Option.option(queryParams.get("title")));
            article.put("spaceKey", io.atlassian.fugue.Option.option(queryParams.get("spaceKey")));
            article.put("applicationId", io.atlassian.fugue.Option.option(queryParams.get("applicationId")));
            return io.atlassian.fugue.Option.some(article);
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("There was an error parsing the article from the comment: {}", (Object[])e.getStackTrace());
            return io.atlassian.fugue.Option.none();
        }
    }

    private static String getIdFromUrl(URL url) {
        String[] paths = Pattern.compile("/").split(url.getPath());
        return paths[paths.length - 1];
    }
}

