/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.conditions;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.plugins.kb.internal.bootstrap.featureflag.KBFeatureFlags;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KBIssueViewEnabledCondition
implements Condition {
    private final FeatureManager featureManager;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskService serviceDeskService;

    @Autowired
    public KBIssueViewEnabledCondition(FeatureManager featureManager, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskService serviceDeskService) {
        this.featureManager = featureManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskService = serviceDeskService;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        ApplicationUser user = (ApplicationUser)map.get("user");
        Project project = (Project)map.get("project");
        if (user != null && project != null) {
            return this.featureManager.isEnabled(KBFeatureFlags.KB_ISSUEVIEW_PANEL) && this.isAgentForServiceDesk(user, project);
        }
        return false;
    }

    private boolean isAgentForServiceDesk(ApplicationUser user, Project project) {
        return (Boolean)Steps.begin((Either)this.serviceDeskService.getServiceDeskForProject(user, project)).then(serviceDesk -> this.serviceDeskPermissionService.isAgent(user, serviceDesk)).yield((serviceDesk, isAgent) -> isAgent).getOrElse((Object)false);
    }
}

