/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.article;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.plugins.kb.internal.article.ArticleService;
import com.atlassian.servicedesk.plugins.kb.internal.article.ArticlesSearchResultsConverter;
import com.atlassian.servicedesk.plugins.kb.internal.model.Article;
import com.atlassian.servicedesk.plugins.kb.internal.search.KbArticleSearchQuery;
import com.atlassian.servicedesk.plugins.kb.internal.search.SearchResults;
import com.atlassian.servicedesk.plugins.kb.internal.search.SearchService;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ArticleServiceImpl
implements ArticleService {
    private final ErrorResultHelper errorResultHelper;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskService serviceDeskService;
    private final SearchService searchService;
    private final ArticlesSearchResultsConverter articlesSearchResultsConverter;
    private final PortalService portalService;
    private final ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final ApplicationLinkErrors applicationLinkErrors;
    private static final Logger logger = LoggerFactory.getLogger(ArticleServiceImpl.class);
    private static final String CONFLUENCE_5_10_VERSION = "5.10.0";

    @Autowired
    public ArticleServiceImpl(ErrorResultHelper errorResultHelper, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskService serviceDeskService, SearchService searchService, ArticlesSearchResultsConverter articlesSearchResultsConverter, PortalService portalService, ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService, ServiceDeskAppLinkService serviceDeskAppLinkService, ApplicationLinkErrors applicationLinkErrors) {
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskService = serviceDeskService;
        this.searchService = searchService;
        this.articlesSearchResultsConverter = articlesSearchResultsConverter;
        this.portalService = portalService;
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.applicationLinkErrors = applicationLinkErrors;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<Article>> searchArticles(ApplicationUser user, Project project, String query, Iterable<String> labels, boolean highlight) {
        return Steps.begin((io.atlassian.fugue.Either)this.confluenceKnowledgeBaseService.getKBLink(user, project)).then(kbLink -> this.isConfluenceVersionSufficientForViewPermissionSearch((ConfluenceKnowledgeBaseLink)kbLink)).then((kbLink, isSufficientVersion) -> this.performSearch(user, (Option<ApplicationUser>)Option.some((Object)user), project, query, labels, highlight, (boolean)isSufficientVersion, (ConfluenceKnowledgeBaseLink)kbLink)).yield((kbLink, isSufficientVersion, articles) -> articles);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<Article>> searchArticlesInIssueContext(ApplicationUser user, Issue issue, String query, boolean highlight) {
        if (StringUtils.isBlank((String)query)) {
            return io.atlassian.fugue.Either.right((Object)Lists.newArrayList());
        }
        return Steps.begin(this.getProject(issue)).then(project -> this.confluenceKnowledgeBaseService.getKBLink(user, project)).then((project, kbLink) -> this.checkConfluenceVersionAndServiceDeskAgent(user, (Project)project, (ConfluenceKnowledgeBaseLink)kbLink)).then((project, kbLink, isSufficientVersion) -> this.getReporter(issue)).then((project, kbLink, isSufficientVersion, reporter) -> this.performSearch(user, (Option<ApplicationUser>)reporter, (Project)project, query, Collections.EMPTY_LIST, highlight, (boolean)isSufficientVersion, (ConfluenceKnowledgeBaseLink)kbLink)).yield((project, kbLink, isSufficientVersion, reporter, articles) -> articles);
    }

    private io.atlassian.fugue.Either<AnError, Boolean> checkConfluenceVersionAndServiceDeskAgent(ApplicationUser user, Project project, ConfluenceKnowledgeBaseLink kbLink) {
        return Steps.begin(this.checkUserIsServiceDeskAgent(user, project)).then(isAgent -> this.isConfluenceVersionSufficientForViewPermissionSearch(kbLink)).then((isAgent, isSufficientVersion) -> this.convertInsufficientVersionToError((Boolean)isSufficientVersion)).yield((isAgent, isSufficientVersion, checkedVersion) -> checkedVersion != false && isAgent != false);
    }

    private io.atlassian.fugue.Either<AnError, Boolean> isConfluenceVersionSufficientForViewPermissionSearch(ConfluenceKnowledgeBaseLink kbLink) {
        return Steps.begin((io.atlassian.fugue.Either)this.serviceDeskAppLinkService.getApplicationLink(kbLink.getApplicationId())).then(applicationLink -> this.serviceDeskAppLinkService.isAppLinkVersionGreaterThanOrEqualTo(applicationLink, CONFLUENCE_5_10_VERSION)).yield((applicationLink, isSufficientVersion) -> isSufficientVersion);
    }

    private io.atlassian.fugue.Either<AnError, Boolean> convertInsufficientVersionToError(Boolean isSufficientVersion) {
        return isSufficientVersion != false ? io.atlassian.fugue.Either.right((Object)isSufficientVersion) : io.atlassian.fugue.Either.left((Object)this.applicationLinkErrors.CONFLUENCE_VERSION_UPGRADE_REQUIRED());
    }

    private io.atlassian.fugue.Either<AnError, List<Article>> performSearch(ApplicationUser user, Option<ApplicationUser> reporter, Project project, String query, Iterable<String> labels, boolean highlight, boolean isSufficientVersion, ConfluenceKnowledgeBaseLink kbLink) {
        if (query.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)Lists.newArrayList());
        }
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user, project))).then(portal -> this.searchService.performSearch(user, this.buildKbArticleSearchQuery(reporter, project, query, labels, highlight), isSufficientVersion, kbLink)).then((portal, searchResults) -> this.articlesSearchResultsConverter.searchResultsToArticles((SearchResults)searchResults, (Portal)portal, kbLink, isSufficientVersion)).yield((portal, searchResults, articles) -> articles);
    }

    private KbArticleSearchQuery buildKbArticleSearchQuery(Option<ApplicationUser> reporter, Project project, String query, Iterable<String> labels, Boolean highlight) {
        return this.searchService.newQueryBuilder(project).permissionCheckedUser(reporter).query(query).labels(labels).highlight(highlight).build();
    }

    private io.atlassian.fugue.Either<AnError, Option<ApplicationUser>> getReporter(Issue issue) {
        if (issue.getReporter() == null) {
            logger.info(String.format("No issue reporter identified for issue %s. Using anonymous", issue.getKey()));
            return io.atlassian.fugue.Either.right((Object)Option.none());
        }
        return io.atlassian.fugue.Either.right((Object)Option.some((Object)issue.getReporter()));
    }

    private io.atlassian.fugue.Either<AnError, Project> getProject(Issue issue) {
        return Option.option((Object)issue.getProjectObject()).toRight(() -> this.errorResultHelper.anError(412, "sd.knowledge.base.no.project", new Object[0]));
    }

    private io.atlassian.fugue.Either<AnError, Boolean> checkUserIsServiceDeskAgent(ApplicationUser user, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project))).then(serviceDesk -> StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user, serviceDesk))).yield((serviceDesk, isAgent) -> new Pair(isAgent, (Object)user)).flatMap(isAgentUserPair -> Eithers.cond((boolean)((Boolean)isAgentUserPair.left()), (Object)this.errorResultHelper.anError(412, "sd.knowledge.base.user.not.service.desk.agent", new Object[0]), (Object)true));
    }
}

