/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.webhook.rulethen;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import com.atlassian.servicedesk.plugins.automation.webhook.rulethen.WebhookThenActionHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class WebhookThenActionValidator
implements ThenActionValidator {
    private static final List<String> ALLOWED_SCHEMES = ImmutableList.of((Object)"HTTP", (Object)"HTTPS");
    private WebhookThenActionHelper webhookThenActionHelper;

    public WebhookThenActionValidator(WebhookThenActionHelper webhookThenActionHelper) {
        this.webhookThenActionHelper = webhookThenActionHelper;
    }

    public ValidationResult validate(@Nonnull ThenActionValidator.ThenActionValidationParam thenActionValidationParam) {
        ConfigurationData data;
        ApplicationUser userToValidateWith = thenActionValidationParam.getUserToValidateWith();
        List<String> errorMessages = this.getValidationErrorMessages(userToValidateWith, data = thenActionValidationParam.getConfiguration().getData());
        if (!errorMessages.isEmpty()) {
            HashMap fieldErrors = Maps.newHashMap();
            fieldErrors.put("url", errorMessages);
            return ValidationResult.FAILED((Map)fieldErrors);
        }
        return ValidationResult.PASSED();
    }

    private List<String> getValidationErrorMessages(ApplicationUser user, ConfigurationData configurationData) {
        Either<ThenActionError, String> urlEither = this.webhookThenActionHelper.getUrlString(user, configurationData);
        return (List)urlEither.fold(url -> this.webhookThenActionHelper.generateErrorMessage(user, "sd.action.webhook.url.missing"), url -> {
            try {
                URI uri = new URI((String)url);
                ArrayList validationErrors = Lists.newArrayList();
                if (!this.isProtocolValid(uri)) {
                    validationErrors.addAll(this.webhookThenActionHelper.generateErrorMessage(user, "sd.action.webhook.url.invalid.protocol"));
                }
                return validationErrors;
            }
            catch (URISyntaxException e) {
                return this.webhookThenActionHelper.generateErrorMessage(user, "sd.action.webhook.url.invalid");
            }
        });
    }

    private boolean isProtocolValid(URI uri) {
        String scheme = uri.getScheme();
        return scheme != null && ALLOWED_SCHEMES.contains(scheme.toUpperCase());
    }
}

