/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.webhook.rulethen;

import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.api.PayloadFactory;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.spi.Payload;
import com.atlassian.servicedesk.plugins.automation.webhook.rulethen.CommentPayloadFactory;
import com.atlassian.servicedesk.plugins.automation.webhook.rulethen.IssueBeanFactory;
import com.atlassian.servicedesk.plugins.automation.webhook.rulethen.WebhookPayload;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WebhookPayloadFactory
implements PayloadFactory {
    private final IssueBeanFactory issueBeanFactory;
    private final CommentPayloadFactory commentPayloadFactory;
    private final UserBeanFactory userBeanFactory;

    @Autowired
    public WebhookPayloadFactory(IssueBeanFactory issueBeanFactory, CommentPayloadFactory commentPayloadFactory, UserBeanFactory userBeanFactory) {
        this.issueBeanFactory = issueBeanFactory;
        this.commentPayloadFactory = commentPayloadFactory;
        this.userBeanFactory = userBeanFactory;
    }

    @Override
    public Payload create(@Nonnull ThenAction.ThenActionParam thenActionParam) {
        WebhookPayload.Builder payloadBuilder = WebhookPayload.builder();
        Option<IssueBean> issueBeen = this.issueBeanFactory.create(thenActionParam.getMessage());
        if (issueBeen.isDefined()) {
            payloadBuilder.setIssue((IssueBean)issueBeen.get());
        }
        payloadBuilder.setComment((CommentJsonBean)this.commentPayloadFactory.getCommentBean(thenActionParam).getOrNull());
        payloadBuilder.setUser((UserJsonBean)this.getUserBean(thenActionParam).getOrNull());
        payloadBuilder.setTimestamp(this.now());
        return payloadBuilder.build();
    }

    private Option<UserJsonBean> getUserBean(@Nonnull ThenAction.ThenActionParam thenActionParam) {
        return Option.option((Object)this.userBeanFactory.createBean(thenActionParam.getUser(), thenActionParam.getUser()));
    }

    private long now() {
        return System.currentTimeMillis();
    }
}

