/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.webhook.executor;

import com.atlassian.fugue.Either;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.util.ServiceDeskApplicationVersionUtil;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.api.WebhookExecutor;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.spi.AnalyticsEventSupplier;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.spi.Payload;
import com.atlassian.servicedesk.plugins.automation.webhook.internal.spi.WebhookSigner;
import com.atlassian.servicedesk.plugins.automation.webhook.rulethen.PayloadSerializer;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@ParametersAreNonnullByDefault
public class WebhookExecutorImpl
implements WebhookExecutor {
    private static final String DEFAULT_CONTENT_TYPE = ContentType.APPLICATION_JSON.toString();
    private final HttpClient httpClient;
    private final AnalyticsService analyticsService;
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final PayloadSerializer payloadSerializer;
    private static final Logger log = LoggerFactory.getLogger(WebhookExecutorImpl.class);

    @Autowired
    public WebhookExecutorImpl(HttpClientFactory httpClientFactory, AnalyticsService analyticsService, ThenActionErrorHelper thenActionErrorHelper, PayloadSerializer payloadSerializer, ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil) {
        this.analyticsService = analyticsService;
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.payloadSerializer = payloadSerializer;
        this.httpClient = this.buildHttpClient(httpClientFactory, serviceDeskApplicationVersionUtil.getServiceDeskApplicationVersion());
    }

    @Override
    public io.atlassian.fugue.Either<ThenActionError, Response> executeWebhook(String absoluteUrl, Map<String, String> headers, Optional<Payload> payload, WebhookSigner webhookSigner, AnalyticsEventSupplier analyticsEventSupplier) {
        io.atlassian.fugue.Either<ThenActionError, URI> uriEither = this.toUri(absoluteUrl);
        if (uriEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)uriEither.left().get());
        }
        URI uri = (URI)uriEither.right().get();
        Request.Builder requestBuilder = this.httpClient.newRequest(uri);
        this.addJsonPayloadIfExists(requestBuilder, payload);
        this.addRequestHeaders(requestBuilder, headers);
        webhookSigner.sign(requestBuilder, uri);
        Response response = null;
        Exception exception = null;
        long start = System.currentTimeMillis();
        try {
            response = (Response)requestBuilder.post().get();
            if (response.isSuccessful()) {
                io.atlassian.fugue.Either either = io.atlassian.fugue.Either.right((Object)response);
                return either;
            }
            io.atlassian.fugue.Either either = StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(String.format("Received [%d - %s] when posting to webhook URL %s", response.getStatusCode(), response.getStatusText(), uri)));
            return either;
        }
        catch (ExecutionException e) {
            exception = e;
            io.atlassian.fugue.Either either = StepsConverters.newerEither((Either)this.thenActionErrorHelper.error("Unable to obtain status code from webhook server: " + e.getMessage()));
            return either;
        }
        catch (InterruptedException e) {
            exception = e;
            throw new RuntimeException(e);
        }
        finally {
            long durationMs = System.currentTimeMillis() - start;
            AnalyticsEvent webhookExecutedEvent = analyticsEventSupplier.executed(uri, headers, payload, response, durationMs);
            this.analyticsService.fireAnalyticsEvent(webhookExecutedEvent);
            this.logRequest(absoluteUrl, headers, (Option<Response>)Option.option((Object)response), (Option<Exception>)Option.option((Object)exception));
        }
    }

    private io.atlassian.fugue.Either<ThenActionError, URI> toUri(String urlString) {
        try {
            return io.atlassian.fugue.Either.right((Object)new URI(urlString));
        }
        catch (URISyntaxException e) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(e.getMessage()));
        }
    }

    private void addRequestHeaders(Request.Builder requestBuilder, Map<String, String> headers) {
        headers.entrySet().stream().forEach(entry -> requestBuilder.setHeader((String)entry.getKey(), (String)entry.getValue()));
    }

    private void addJsonPayloadIfExists(Request.Builder requestBuilder, Optional<Payload> payload) {
        if (payload.isPresent()) {
            String payloadJson = this.payloadSerializer.serialize(payload.get());
            ((Request.Builder)requestBuilder.setContentType(DEFAULT_CONTENT_TYPE)).setEntity(payloadJson);
        }
    }

    private String buildUserAgentWithSDVersion(HttpClientOptions httpClientOptions, String servicedeskVersion) {
        return String.format("JIRA-Service-Desk-%s / %s", servicedeskVersion, httpClientOptions.getUserAgent());
    }

    private HttpClient buildHttpClient(HttpClientFactory httpClientFactory, String servicedeskVersion) {
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        String userAgent = this.buildUserAgentWithSDVersion(httpClientOptions, servicedeskVersion);
        httpClientOptions.setUserAgent(userAgent);
        return httpClientFactory.create(httpClientOptions);
    }

    private void logRequest(String absoluteUrl, Map<String, String> headers, Option<Response> response, Option<Exception> exception) {
        boolean isSuccessful = (Boolean)response.map(Response::isSuccessful).getOrElse((Object)false);
        log.debug("JSD webhook request {}:\n------------------------------------------------------------\nurl: {}\nheaders: {}\nresponse code: {}\nexception: {}\n------------------------------------------------------------", new Object[]{isSuccessful ? "successful" : "failed", absoluteUrl, headers, response.map(Response::getStatusCode).getOrNull(), exception.map(Object::toString).getOrNull()});
    }
}

