/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.webhook.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

@EventName(value="servicedesk.automation.webhook.then.action.executed")
public class WebhookExecutedAnalyticsEvent
extends AnalyticsEvent {
    @Nullable
    private final Integer responseHttpStatusCode;
    private final Boolean payloadSent;
    @Nullable
    private final Long projectId;
    @Nullable
    private final Long ruleSetId;
    private final Integer numHeaders;
    private final String urlHash;
    private final String hostHash;
    private final Long durationMs;

    protected WebhookExecutedAnalyticsEvent(Integer responseHttpStatusCode, Boolean payloadSent, Long projectId, Long ruleSetId, Integer numHeaders, String urlHash, String hostHash, Long durationMs) {
        this.responseHttpStatusCode = responseHttpStatusCode;
        this.payloadSent = (Boolean)Preconditions.checkNotNull((Object)payloadSent);
        this.projectId = projectId;
        this.ruleSetId = ruleSetId;
        this.numHeaders = (Integer)Preconditions.checkNotNull((Object)numHeaders);
        this.urlHash = (String)Preconditions.checkNotNull((Object)urlHash);
        this.hostHash = (String)Preconditions.checkNotNull((Object)hostHash);
        this.durationMs = (Long)Preconditions.checkNotNull((Object)durationMs);
    }

    public Integer getResponseHttpStatusCode() {
        return this.responseHttpStatusCode;
    }

    public Boolean getPayloadSent() {
        return this.payloadSent;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getRuleSetId() {
        return this.ruleSetId;
    }

    public Integer getNumHeaders() {
        return this.numHeaders;
    }

    public String getUrlHash() {
        return this.urlHash;
    }

    public String getHostHash() {
        return this.hostHash;
    }

    public Long getDurationMs() {
        return this.durationMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebhookExecutedAnalyticsEvent data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WebhookExecutedAnalyticsEvent that = (WebhookExecutedAnalyticsEvent)((Object)o);
        return Objects.equals(this.getResponseHttpStatusCode(), that.getResponseHttpStatusCode()) && Objects.equals(this.getPayloadSent(), that.getPayloadSent()) && Objects.equals(this.getProjectId(), that.getProjectId()) && Objects.equals(this.getRuleSetId(), that.getRuleSetId()) && Objects.equals(this.getNumHeaders(), that.getNumHeaders()) && Objects.equals(this.getUrlHash(), that.getUrlHash()) && Objects.equals(this.getHostHash(), that.getHostHash()) && Objects.equals(this.getDurationMs(), that.getDurationMs());
    }

    public int hashCode() {
        return Objects.hash(this.getResponseHttpStatusCode(), this.getPayloadSent(), this.getProjectId(), this.getRuleSetId(), this.getNumHeaders(), this.getUrlHash(), this.getHostHash(), this.getDurationMs());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("responseHttpStatusCode", (Object)this.getResponseHttpStatusCode()).add("payloadSent", (Object)this.getPayloadSent()).add("projectId", (Object)this.getProjectId()).add("ruleSetId", (Object)this.getRuleSetId()).add("numHeaders", (Object)this.getNumHeaders()).add("urlHash", (Object)this.getUrlHash()).add("hostHash", (Object)this.getHostHash()).add("durationMs", (Object)this.getDurationMs()).toString();
    }

    public static final class Builder {
        private Integer responseHttpStatusCode;
        private Boolean payloadSent;
        private Long projectId;
        private Long ruleSetId;
        private Integer numHeaders;
        private String urlHash;
        private String hostHash;
        private Long durationMs;

        private Builder() {
        }

        private Builder(WebhookExecutedAnalyticsEvent initialData) {
            this.responseHttpStatusCode = initialData.getResponseHttpStatusCode();
            this.payloadSent = initialData.getPayloadSent();
            this.projectId = initialData.getProjectId();
            this.ruleSetId = initialData.getRuleSetId();
            this.numHeaders = initialData.getNumHeaders();
            this.urlHash = initialData.getUrlHash();
            this.hostHash = initialData.getHostHash();
            this.durationMs = initialData.getDurationMs();
        }

        public Builder setResponseHttpStatusCode(Integer responseHttpStatusCode) {
            this.responseHttpStatusCode = responseHttpStatusCode;
            return this;
        }

        public Builder setPayloadSent(Boolean payloadSent) {
            this.payloadSent = payloadSent;
            return this;
        }

        public Builder setProjectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setRuleSetId(Long ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public Builder setNumHeaders(Integer numHeaders) {
            this.numHeaders = numHeaders;
            return this;
        }

        public Builder setUrlHash(String urlHash) {
            this.urlHash = urlHash;
            return this;
        }

        public Builder setHostHash(String hostHash) {
            this.hostHash = hostHash;
            return this;
        }

        public Builder setDurationMs(Long durationMs) {
            this.durationMs = durationMs;
            return this;
        }

        public WebhookExecutedAnalyticsEvent build() {
            return new WebhookExecutedAnalyticsEvent(this.responseHttpStatusCode, this.payloadSent, this.projectId, this.ruleSetId, this.numHeaders, this.urlHash, this.hostHash, this.durationMs);
        }
    }
}

