define("servicedesk/internal/agent/settings/automation/view/rule-view", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/view/rule-component-summary-view",
    "servicedesk/internal/agent/settings/automation/view/if-then-view",
    "servicedesk/internal/agent/settings/automation/view/add-if-then-view",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics"
], function (
    $,
    _,
    Brace,
    RuleComponentSummaryView,
    IfThenView,
    AddIfThenView,
    tracker
    ) {

    return Brace.View.extend({
        className: "rule-container",

        template: ServiceDesk.Templates.Agent.Settings.rule,

        namedEvents: [
            "componentSelected",
            "componentDeleted"
        ],

        initialize: function() {
            this.listenTo(this.model.getIfThens(), "modelChanged", _.bind(this._onIfThensChanged, this));
        },

        render: function () {
            this.$el.html(this.template({}));

            // Render when handlers
            var when = this.model.getWhen();

            if (when) {
                var whenHandlerContainer = this.$(".when-handler-container");
                this.whenHandlerView = new RuleComponentSummaryView({
                    model: when,
                    type: "whenHandler"
                }).render();
                whenHandlerContainer.append(this.whenHandlerView.el);
                this.listenTo(this.whenHandlerView, "componentSelected", _.bind(this._componentSelected, this));
            }

            // Render if thens
            var ifThens = this.model.getIfThens();
            var ifThenContainer = this.$(".if-then-outer-container");

            if (ifThens) {
                this.ifThenViews = [];
                ifThens.each(_.bind(function (ifThen, index) {
                    var view = new IfThenView({
                        model: ifThen,
                        isFirst: index == 0,
                        isLast: index == (ifThens.length - 1)
                    }).render();
                    ifThenContainer.append(view.el);

                    this.listenTo(view, "componentSelected", _.bind(this._componentSelected, this));
                    this.listenTo(view, "componentDelete", _.bind(this._componentDelete, this));
                    this.listenTo(view, "componentMoveUp", _.bind(this._componentMoveUp, this));
                    this.listenTo(view, "componentMoveDown", _.bind(this._componentMoveDown, this));

                    this.ifThenViews.push(view);
                }, this));
            }

            // Render "add new if then" section
            this.addIfthenView = new AddIfThenView().render();
            this._setAddIfThenDisabledState();

            ifThenContainer.append(this.addIfthenView.el);
            this.listenTo(this.addIfthenView, "addRequested", _.bind(this._addIfThenRequested, this));
            $(document).trigger("automationRuleRendered");

            return this;
        },

        unselectAll: function () {
            if (this.whenHandlerView) {
                this.whenHandlerView.unselect();
            }

            if (this.ifThenViews) {
                _.each(this.ifThenViews, function (view) {
                    view.unselectAll();
                });
            }
        },

        focus: function () {
            if (this.whenHandlerView) {
                this.whenHandlerView.focus();
            }
        },

        // Event handlers
        _addIfThenRequested: function() {
            // Duplicate the last if then.
            var ifThens = this.model.getIfThens();
            if (ifThens) {
                tracker.trackEvent("automation.ruleset.edit.ifthen.add");

                var last = ifThens.last();
                this.model.getIfThens().add(last.toJSON());

                this.render();
                var lastIfThenView = _.last(this.ifThenViews);
                _.defer(_.bind(lastIfThenView.select, lastIfThenView));
            }
        },

        _componentMoveDown: function(data) {
            var ifThen = this._findIfThen(data.model);

            if (ifThen) {
                var ifThens = this.model.getIfThens();
                var currentIndex = ifThens.indexOf(ifThen);
                if (currentIndex !== -1 && currentIndex !== ifThens.length - 1) {
                    tracker.trackEvent("automation.ruleset.edit.ifthen.move.down");

                    var newIndex = currentIndex + 1;
                    this._moveIfThen(ifThen, newIndex);
                    var movedIfThenView = this.ifThenViews[newIndex];
                    _.defer(_.bind(movedIfThenView.select, movedIfThenView));
                }
            }
        },

        _componentMoveUp: function(data) {
            var ifThen = this._findIfThen(data.model);

            if (ifThen) {
                var currentIndex = this.model.getIfThens().indexOf(ifThen);
                if (currentIndex > 0) {
                    tracker.trackEvent("automation.ruleset.edit.ifthen.move.up");

                    var newIndex = currentIndex - 1;
                    this._moveIfThen(ifThen, newIndex);
                    var movedIfThenView = this.ifThenViews[newIndex];
                    _.defer(_.bind(movedIfThenView.select, movedIfThenView));
                }
            }
        },

        _componentSelected: function(data) {
            this.triggerComponentSelected(data);
        },

        _componentDelete: function(data) {
            var ifThen = this._findIfThen(data.model);

            tracker.trackEvent("automation.ruleset.edit.ifthen.delete");

            this.model.getIfThens().remove(ifThen);
            this.render();
            this.triggerComponentDeleted();
        },

        _onIfThensChanged: function() {
            this._setAddIfThenDisabledState();
        },

        // Helper Functions
        _findIfThen: function(model) {
            return this.model.getIfThens().find(function(ifThen) {
                return ifThen.getIf() === model;
            });
        },

        _moveIfThen: function(model, newIndex) {
            this.model.getIfThens().remove(model);
            this.model.getIfThens().add(model, { at: newIndex });
            this.render();
        },

        _setAddIfThenDisabledState: function() {
            var ifThens = this.model.getIfThens();
            var lastIf = ifThens.last().getIf();

            if (lastIf && lastIf.getIfConditions() && lastIf.getIfConditions().length === 0) {
                this.addIfthenView.disable();
            } else {
                this.addIfthenView.enable();
            }
        },
    });
});