define("servicedesk/internal/agent/settings/automation/view/picker/rule-component-picker", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/trace/trace",
    "servicedesk/internal/agent/settings/automation/util/form-mixin/form-mixin",
    "servicedesk/internal/agent/settings/automation/model/picker/if-condition-search-model",
    "servicedesk/internal/agent/settings/automation/model/picker/then-action-search-model",
    "servicedesk/internal/agent/settings/automation/model/picker/when-handler-search-model",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics"
], function (
    $,
    _,
    Brace,
    Trace,
    FormMixin,
    IfConditionSearchModel,
    ThenActionSearchModel,
    WhenHandlerSearchModel,
    tracker
    ) {

    return Brace.View.extend({
        tagName: "form",
        mixins: [FormMixin],
        className: "aui top-label",
        templateCollapsed: ServiceDesk.Templates.Agent.Settings.Picker.automationSearcherCollapsed,
        templateExpanded: ServiceDesk.Templates.Agent.Settings.Picker.automationSearcherExpanded,
        namedEvents: [
            "addModule"
        ],
        events: {
            "click a.cancel": "_cancel",
            "click a.add": "_add",
            "submit": "_onSubmit"
        },

        initialize: function(opts) {
            this.type = opts.type;
            this.ruleModel = opts.ruleModel;
            this.model = this._buildModel(this.type);
        },

        render: function(isExpanded) {
            this._hideSpinner();
            var render;
            if (isExpanded) {
                render = this._renderExpanded();
            } else {
                render = this._renderCollapsed();
            }

            this.focus();
            return render;
        },

        expand: function() {
            this._showSpinner();
            this.search().done(_.bind(function() {
                this.render(true);
            }, this));
        },

        collapse: function() {
            this.render(false);
        },

        search: function() {
            return this.model.search().done(_.bind(this.render, this));
        },

        hide: function() {
            this.collapse();
            this.$el.addClass("hidden");
        },

        show: function() {
            this.collapse();
            this.$el.removeClass("hidden");
        },

        focus: function() {
            if (this._isExpanded()) {
                this.$('.automation-search-container-expanded').find('#automation-module-picker-field').focus();
            } else {
                this.$('.automation-search-container-collapsed').find('.add').focus();
            }
        },

        /* Event handlers */

        _cancel: function(e) {
            e && e.preventDefault();

            tracker.trackEvent("automation.ruleset.edit." + this.type + ".configuration.add.cancel");

            this.collapse();
        },

        _add: function(e) {
            e && e.preventDefault();

            tracker.trackEvent("automation.ruleset.edit." + this.type + ".configuration.add");

            this.expand();
        },

        _onSubmit: function(e) {
            e && e.preventDefault();
            if (this.singleSelect) {
                var selectedModuleKey = this.singleSelect.model.$element.find(":selected").attr('value');

                if (selectedModuleKey && selectedModuleKey.trim() !== "") {
                    var selectedModel = this.model.getResults().getCollection().find(function (result) {
                        return result.getModuleKey() === selectedModuleKey;
                    });

                    tracker.trackEvent("automation.ruleset.edit." + selectedModel.getType() + ".configuration.add.confirm", {
                        moduleKey: selectedModuleKey
                    });

                    this.triggerAddModule({
                        view: this,
                        model: selectedModel
                    })
                }
            }
        },

        /* UI Helper methods */

        // Hides the "add" link and replaces it with a spinner
        _showSpinner: function() {
            this.$('.add').hide();
            this.showSpinner();
        },

        // Shows the "add" link and removes the spinner
        _hideSpinner: function() {
            this.$('.add').show();
            this.hideSpinner();
        },

        /* Other methods */

        // Builds the relevant search model which holds the search results and query depending on the type of the component
        _buildModel: function (type) {
            switch (type) {
                case "whenHandler":
                    return new WhenHandlerSearchModel();
                case "ifCondition":
                    return new IfConditionSearchModel();
                case "thenAction":
                    return new ThenActionSearchModel();
            }
        },

        _getAddLinkText: function(type) {
            switch (type) {
                case "whenHandler":
                    return AJS.I18n.getText('sd.automation.component.picker.add.when');
                case "ifCondition":
                    return AJS.I18n.getText('sd.automation.component.picker.add.if');
                case "thenAction":
                    return AJS.I18n.getText('sd.automation.component.picker.add.then');
            }
        },

        _renderExpanded: function() {
            this.$el.empty();
            var renderModels = [];
            var resultCollection = this.model.getCompatibleResultCollection(this.ruleModel);
            if (resultCollection) {
                renderModels = resultCollection.map(function (result) {
                    return {
                        value: result.getModuleKey(),
                        text: result.getName()
                    }
                });
            }

            this.$el.html(this.templateExpanded({
                modules: renderModels
            }));

            this.singleSelect = new AJS.SingleSelect({
                element: this.$('#automation-module-picker'),
                itemAttrDisplayed: "label",
                width: 250, //property necessary  to work in JIRA 5.1.8 and IE8
                revertOnInvalid: true
            });

            this.singleSelect.clear();

            Trace("automation.picker.expand.render.complete");

            return this;
        },

        _renderCollapsed: function() {
            this.$el.empty();
            this.$el.html(this.templateCollapsed({
                addLinkText: this._getAddLinkText(this.type)
            }));
            return this;
        },

        _isExpanded: function() {
            return this.$('.automation-search-container-expanded').length > 0;
        }
    });

});