define("servicedesk/internal/agent/settings/automation/view/if-then-view", [
    "jquery",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/view/rule-component-summary-view"
], function (
    $,
    Brace,
    RuleComponentSummaryView
    ) {

    return Brace.View.extend({
        className: "if-then-container",

        template: ServiceDesk.Templates.Agent.Settings.IfThen,

        namedEvents: [
            "componentSelected",
            "componentDelete",
            "componentMoveUp",
            "componentMoveDown"
        ],

        initialize: function (opts) {
            this.isLast = opts.isLast;
            this.isFirst = opts.isFirst;
        },

        render: function () {
            this._disableChildView();

            this.$el.html(this.template({
                isLast: this.isLast
            }));

            // Render if condition
            var ifConditionContainer = this.$(".if-condition-container");
            this.ifConditionView = new RuleComponentSummaryView({
                type: "ifCondition",
                model: this.model.getIf(),
                isFirst: this.isFirst,
                isLast: this.isLast
            }).render();
            ifConditionContainer.append(this.ifConditionView.el);

            // Render then condition
            var thenActionContainer = this.$(".then-action-container");
            this.thenActionView = new RuleComponentSummaryView({
                type: "thenAction",
                model: this.model.getThen()
            }).render();
            thenActionContainer.append(this.thenActionView.el);

            // Listen to component selected events to render the details panel
            this._listenToComponentViewEvents(this.ifConditionView);
            this._listenToComponentViewEvents(this.thenActionView);

            return this;
        },

        select: function() {
            if (this.ifConditionView) {
                this.ifConditionView.selectComponent();
            }
        },

        unselectAll: function () {
            this.ifConditionView.unselect();
            this.thenActionView.unselect();
        },

        dispose: function() {
            this._disableChildView();
            this.stopListening();
        },

        _listenToComponentViewEvents: function(componentView) {
            this.listenTo(componentView, "componentSelected", _.bind(this.triggerComponentSelected, this));
            this.listenTo(componentView, "componentDelete", _.bind(this.triggerComponentDelete, this));
            this.listenTo(componentView, "componentMoveUp", _.bind(this.triggerComponentMoveUp, this));
            this.listenTo(componentView, "componentMoveDown", _.bind(this.triggerComponentMoveDown, this));
        },

        _disableChildView: function() {
            if (this.ifConditionView) {
                this.ifConditionView.undelegateEvents();
                this.ifConditionView.stopListening();
                this.ifConditionView.remove();
            }

            if (this.thenActionView) {
                this.thenActionView.undelegateEvents();
                this.thenActionView.stopListening();
                this.thenActionView.remove();
            }
        }
    });

});