define("servicedesk/internal/agent/settings/automation/view/help/rule-set-help", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/html-utils/html-utils",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics"
], function (
    $,
    _,
    Brace,
    HtmlUtils,
    tracker
) {

    return Brace.View.extend({
        className: 'rule-set-help-container',
        template: ServiceDesk.Templates.Agent.Settings.Help.ruleSetHelpSection,

        initialize: function(opt) {
            this.hasInitializedBefore = opt.hasInitializedBefore;

            // This is only used when hasInitializedBefore is true
            this.forceCollapsed = opt.forceCollapsed;
        },

        render: function() {
            var htmlToSanitize = this.model.getDetailAsHtml();
            var detailAsHtml = HtmlUtils.sanitizeMarkup(htmlToSanitize);
            
            this.$el.html(this.template({
                title: this.model.getTitle(),
                description: this.model.getDescription(),
                detailAsHtml: detailAsHtml
            }));


            this.$el.find('.aui-expander-trigger').on('aui-expander-expanded', function() {
                tracker.trackEvent("automation.help.text.request.expand");

                try {
                    window.localStorage.setItem("sd.automation.help.text.is.collapsed", "false");
                } catch (ex) {
                    // Browser does not support local storage
                }

            });

            this.$el.find('.aui-expander-trigger').on('aui-expander-collapsed', function() {
                tracker.trackEvent("automation.help.text.request.collapse");

                try {
                    window.localStorage.setItem("sd.automation.help.text.is.collapsed", "true");
                } catch (ex) {
                    // Browser does not support local storage
                }
            });


            // This is used to maintain expand/collapse on re-render when localStorage is turned off.
            var forceCollapse = ((this.hasInitializedBefore && this.forceCollapsed) || this._shouldCollapseOnRender());


            if (forceCollapse) {
                this.collapse();
            } else {
                // need to set the aria-expanded attribute manually instead of calling trigger
                // because this is for rendering on default
                this.expandDefault();
            }

            return this;
        },

        expandDefault: function() {
            this.$el.find('.aui-expander-content').attr('aria-expanded', "true");
        },

        collapse:function() {
            this.$el.find('.aui-expander-trigger').trigger('aui-expander-collapse');
        },

        isExpanded: function() {
            var currentElementExpandedState = this.$el.find('.aui-expander-content').attr('aria-expanded');

            if (!currentElementExpandedState) {
                return this._getSavedExpandedState();
            } else {
                return currentElementExpandedState === "true";
            }
        },

        _shouldCollapseOnRender: function() {
            var savedExpandedState = this._getSavedExpandedState();

            return (!savedExpandedState || savedExpandedState === "true");
        },

        _getSavedExpandedState: function() {
            try {
                return window.localStorage.getItem("sd.automation.help.text.is.collapsed");
            } catch (ex) {
                return null; // neither false nor true, localStorage is unavailable.
            }
        }

    });
});