define("servicedesk/internal/agent/settings/automation/view/add-if-then-view", [
    "jquery",
    "automation/backbone-brace"
], function (
    $,
    Brace
    ) {

    return Brace.View.extend({
        className: "if-then-container",
        template: ServiceDesk.Templates.Agent.Settings.addIfThen,
        namedEvents: [
            "addRequested"
        ],

        events: {
            "keydown": "_keyDown",
            "click .add-if-then-button": "_requestAdd"
        },

        render: function () {
            this.$el.html(this.template({}));
            return this;
        },

        _requestAdd: function() {
            var $addIfThenButton = this.$('.add-if-then-button');
            if (!$addIfThenButton.hasClass('disabled')) {
                this.triggerAddRequested();
            }
        },

        disable: function() {
            var $addIfThenButton = this.$('.add-if-then-button');
            $addIfThenButton.removeAttr('tabindex');    // Disable tabbing again
            $addIfThenButton.attr('title', AJS.I18n.getText('sd.automation.component.add.if.then.button.title.disable'));
            $addIfThenButton.addClass('disabled');
            $addIfThenButton.prop('disabled', true);
        },

        enable: function() {
            var $addIfThenButton = this.$('.add-if-then-button');
            $addIfThenButton.attr('tabindex', 0);       // Enable tabbing again
            $addIfThenButton.attr('title', AJS.I18n.getText('sd.automation.component.add.if.then.button.title'));
            $addIfThenButton.removeClass('disabled');
            $addIfThenButton.removeProp('disabled');
        },

        _keyDown: function(e) {
            if (e.keyCode === 13) {
                e.preventDefault();
                this.triggerAddRequested();
            }
        }
    });
});