define("servicedesk/internal/agent/settings/automation/util/navigator/navigator", [
    "automation/backbone",
    "exports"
], function (Backbone,
             exports) {

    var externalNavigationCallback;

    function navigateToFragment(path) {
        Backbone.history.navigate(path, {
            trigger: true
        });
    };

    /**
     * Set a callback to call when we want to navigate to a view outside automation settings.
     * We need to do this because there is a use case to navigate back to the original view after saving automation.
     * Since they have different root urls, we need to put a callback here to delegate the navigation to the calling view instead.
     */
    function setExternalNavigationCallback(callBack) {
        externalNavigationCallback = callBack;
    };

    /**
     * Call this function to navigate to a fragment outside automation settings app.
     */
    function navigateToExternalFragment(path) {
        if (externalNavigationCallback) {
            externalNavigationCallback(path);
        } else {
            this.navigateToFragment("");
        }
    };

    exports.navigateToFragment = navigateToFragment;
    exports.navigateToExternalFragment = navigateToExternalFragment;
    exports.setExternalNavigationCallback = setExternalNavigationCallback;

});

