define("servicedesk/internal/agent/settings/automation/util/form-mixin/form-mixin", [
    "automation/underscore"
], function (
    _
) {
    var SHOW_SUCCESS_CALLBACK_DELAY = 800; // The delay before the showSuccess callback is executed

    return {
        showSpinner: function(elOrSelector) {
            if (elOrSelector) {
                var $element = $(elOrSelector);
                $element.spin("small");
            } else {
                this.$(".js-status").addClass("loading");
            }
        },
        hideSpinner: function(elOrSelector) {
            if (elOrSelector) {
                var $element = $(elOrSelector);
                $element.spinStop();
            } else {
                this.$(".js-status").removeClass("loading");
            }
        },
        showSuccess: function(callback, ctx, elOrSelector) {
            var $element = this.$(elOrSelector || ".js-status");
            this.hideSpinner(elOrSelector ? $element : undefined);
            $element.addClass("success");
            if (callback) {
                _.delay(_.bind(callback, ctx), SHOW_SUCCESS_CALLBACK_DELAY);
            }
        },
        disableSubmit: function() {
            this.$(":input[type='submit']").attr({
                "aria-disabled": "aria-disabled",
                "disabled": "disabled"
            });
        },
        enableSubmit: function() {
            this.$(":input[type='submit']")
                .removeAttr("aria-disabled disabled");
        }
    }
});

