define("servicedesk/internal/agent/settings/automation/util/async-utils/async-utils", [
    "jquery",
    "exports"
], function (
    $,
    exports
) {

    function execDeferredFunctionQueue(deferred, funcs, args, ctx) {
        if (funcs && funcs.length) {
            // we do this to avoid mutation of original array.
            var preconditions = funcs.slice(0);
            preconditions[0].apply(ctx, args).done(function () {
                execDeferredFunctionQueue(deferred, preconditions.slice(1), args, ctx);
            }).fail(function () {
                deferred.rejectWith(ctx);
            })
        } else {
            deferred.resolveWith(ctx);
        }
        return deferred;
    }

    /**
     * Executes a queue of functions returning deferreds. Will resolve if all the functions in the queue resolve.
     * Will reject on the first function in the queue rejecting.
     *
     * @param {Array<Function>} funcs - array of functions that return deferreds
     * @param {Array<Any>} args - to be passed in as the arguments when calling each func
     * @param ctx - the "this" inside of of each func as well as in the returned deferred.
     * @returns {jQuery.Deferred}
     */
    exports.execDeferredFunctionQueue = function (funcs, args, ctx) {
        var deferred = $.Deferred();
        funcs = funcs || [];
        args = args || [];
        ctx = ctx || window;
        execDeferredFunctionQueue(deferred, funcs, args, ctx);
        return deferred;
    };
});