define("servicedesk/internal/agent/settings/automation/util/ajax/ajax", [
    "jquery",
    "automation/underscore",
    "exports"
], function (
    $,
    _,
    exports
) {

    function getErrorCollection(xhr) {
        var errorCollection;
        try {
            errorCollection = JSON.parse(xhr.responseText);
        } catch (e) {
            // no error collection so return generic error
            errorCollection = {
                errors: [
                    {errorMessage: AJS.I18n.getText("sd.error.ajax.general")}
                ]
            };
        }
        return errorCollection;
    }

    function markupWithErrors(req) {
        return req.then(null, function(jqXHR) {
            return _.extend(jqXHR, getErrorCollection(jqXHR))
        });
    }

    function doRequest(type, url, data) {
        var params = _.extend({}, defaults, {
            url: url,
            type: type
        });
        if (data) {
            params.data = JSON.stringify(data);
        }
        return markupWithErrors($.ajax(params));
    }

    var defaults = {
        contentType: "application/json",
        dataType: "json"
    };

    exports.get = function (url) {
        return doRequest("get", url);
    };
    exports.del = function (url) {
        return doRequest("delete", url);
    };
    exports.put = function (url, data) {
        return doRequest("put", url, data);
    };
    exports.post = function (url, data) {
        return doRequest("post", url, data);
    };
});