define("servicedesk/internal/agent/settings/automation/page/automation-rule-set-page-module", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/meta/meta",
    "servicedesk/internal/agent/settings/automation/page/automation-rule-set-page-model",
    "servicedesk/internal/agent/settings/automation/page/automation-rule-set-page-blueprint-model",
    "servicedesk/internal/agent/settings/automation/page/automation-rule-set-page-view"
], function (
    $,
    _,
    Brace,
    Meta,
    AutomationRuleSetPageModel,
    AutomationRuleSetPageBluePrintModel,
    AutomationRuleSetPageView
    ) {

    const CONTAINER_SELECTOR = ".js-automation-settings-page-container";

    return Brace.View.extend({
        template: ServiceDesk.Templates.Agent.Settings.container,

        initialize: function () {
            this.ruleSetModel = new AutomationRuleSetPageModel({
                projectKey: Meta.get("projectKey")
            });
            this.bluepintModel = new AutomationRuleSetPageBluePrintModel({
                projectKey: Meta.get("projectKey")
            });
            this.ruleSetView = new AutomationRuleSetPageView({
                model: this.ruleSetModel
            });
            this.blueprintView = new AutomationRuleSetPageView({
                model: this.bluepintModel
            });
        },
        enable: function (state, $el) {
            $el.html(this.template());
            const $container = $el.find(CONTAINER_SELECTOR);

            if (state.mode === "ruleset") {
                this.blueprintView.undelegateEvents();
                this.pageView = this.ruleSetView;
                return this.ruleSetModel.setId(state.entityId).fetch().done(_.bind(function () {
                    this.ruleSetView.setElement($container).render();
                }, this));
            } else if (state.mode === "blueprint") {
                this.ruleSetView.undelegateEvents();
                this.pageView = this.blueprintView;
                return this.bluepintModel.setId(state.entityId).fetch().done(_.bind(function () {
                    this.blueprintView.setElement($container).render();
                }, this));
            }
        },
        disable: function () {
            this.pageModel.abort();
        },
        beforeNavigate: function() {
            var $deferred = $.Deferred();

            if (this.pageView && this.pageView.beforeNavigate) {
                $deferred = this.pageView.beforeNavigate();
            } else {
                $deferred.resolve();
            }

            return $deferred;
        }
    });
});