define("servicedesk/internal/agent/settings/automation/page/automation-rule-set-page-blueprint-model", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/rule-set-model",
    "servicedesk/internal/agent/settings/automation/model/blueprint-detail-model",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax"
], function (
    $,
    _,
    Brace,
    RuleSetModel,
    BlueprintDetailModel,
    Ajax
) {

    return Brace.Model.extend({
        namedEvents: ["fetchedFromServer", "savedOnServer", "validatedOnServer", "ruleSetChanged"],
        namedAttributes: {
            id: String,
            projectKey: String,
            blueprint: BlueprintDetailModel,
            ruleSet: RuleSetModel
        },

        getUrl: function () {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/ruleset/blueprint/" + this.getId() + "/project/" + this.getProjectKey();
        },

        fetch: function () {
            this._pageReq = Ajax
                .get(this.getUrl())
                .done(_.bind(function (data) {
                    var nonNullRuleAndCollectionBlueprint = this._ensureNonNullRuleAndCollection(data);

                    this.set({blueprint: nonNullRuleAndCollectionBlueprint});

                    var newRuleSet = this.getBlueprint().createRuleSetModel();
                    this.set({ruleSet: newRuleSet});

                    this.listenTo(this.getRuleSet(), "modelChanged", this.triggerRuleSetChanged);

                    this.triggerFetchedFromServer(data);
                }, this));
            return this._pageReq;
        },

        abort: function() {
            this._pageReq && !this._pageReq.isResolved() && this._pageReq.abort();
        },

        /**
         * Returns true as this model represents a blueprint. This model is used when the user attempts to create a new rule set.
         */
        isBlueprint: function() {
            return true;
        },

        // This will ensure that all lists in the rule set model is non-null and instead an empty list.
        // We do this so that the collection can be modified and reflected in the model.
        // Preferably the template that we get from the server does not have null lists but we're doing another
        // check here to ensure everything works.
        // We ensure the following assumption is met:
        //  * No null collections
        //  * At least one rule with an empty when,if,then
        _ensureNonNullRuleAndCollection: function(ruleSetModelJson) {
            var rules = ruleSetModelJson.rules ? ruleSetModelJson.rules : [{ }];

            _.each(rules, function(rule) {
                if (!rule.when) {
                    rule.when = { whenHandlers: []};
                }
                else if (!rule.when.whenHandlers) {
                    rule.when.whenHandlers = [];
                }

                if (!rule.ifThens || rule.ifThens.length === 0) {
                    // make sure there is at least one if/then
                    rule.ifThens = [
                        {
                            "if": { ifConditions: [] },
                            then: { thenActions: [] }
                        }
                    ];
                } else {
                    _.each(rule.ifThens, function(ifThen) {
                        if (!ifThen["if"] || !ifThen["if"].ifConditions) {
                            ifThen["if"] = { ifConditions: [] };
                        }

                        if (!ifThen.then || !ifThen.then.thenActions) {
                            ifThen.then = { thenActions: [] };
                        }
                    });
                }
            });

            ruleSetModelJson.rules = rules;

            // If runAsUserContext is not in the metadata, then explicitly set it to undefined.
            // Otherwise the value will be missing and backbone won't set the value, and it will remain whatever it was before.
            var userContext = ruleSetModelJson.metadata.runAsUserContext ? ruleSetModelJson.metadata.runAsUserContext : undefined;
            ruleSetModelJson.metadata.runAsUserContext = userContext;

            return ruleSetModelJson;
        }
    });

});