define("servicedesk/internal/agent/settings/automation/page/automation-list-page-module", [
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/page/automation-list-page-model",
    "servicedesk/internal/agent/settings/automation/page/automation-list-page-view"
], function (
    _,
    Brace,
    AutomationListPageModel,
    AutomationListPageView
    ) {
    const CONTAINER_SELECTOR = ".js-automation-settings-page-container";

    return Brace.View.extend({
        template: ServiceDesk.Templates.Agent.Settings.container,

        enable: function (state, $el) {
            $el.html(this.template());
            const $container = $el.find(CONTAINER_SELECTOR);
            // create the page model, and bind event handlers on it
            this.pageModel = new AutomationListPageModel({
                projectKey: AJS.Meta.get("projectKey")
            });

            // create the page view, and bind event handlers on it
            this.pageView = new AutomationListPageView({
                model: this.pageModel,
                el: $container
            });

            return this.update();
        },
        update: function () {
            return this.pageModel.fetch().done(_.bind(function() {
                this.pageView.render();
                JIRA.trigger("enabled.module.sd", "automation/list");
            }, this));
        },
        disable: function () {
            this.pageView.stopListening();
            this.pageView.undelegateEvents();
            this.pageView.disable && this.pageView.disable();
            this.pageModel.abort();
        }
    });
});