define("servicedesk/internal/agent/settings/automation/page/automation-list-page-list-entry-view", [
    "jquery",
    "automation/underscore",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/feature/confirm-dialog/confirm-dialog",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics",
    "servicedesk/internal/agent/settings/automation/util/navigator/navigator"
], function (
    $,
    _,
    Brace,
    ConfirmationDialog,
    tracker,
    Navigator
    ) {
    return Brace.View.extend({
        tagName: "li",
        className: "rule-set-list-entry",
        template: ServiceDesk.Templates.Agent.Settings.automationSettingsListEntry,
        templateError: ServiceDesk.Templates.Agent.Settings.automationSettingsListEntryError,
        events: {
            "click .edit-rule-set-link": "editRuleSet",
            "click .view-audit-log-link": "viewAuditLog"
        },

        namedEvents: ["saveRunAsUserClicked"],

        initialize: function(opts) {
            this.projectRunAsUserSettings = opts.projectRunAsUserSettings
        },

        render: function () {
            var projectKey = AJS.Meta.get("projectKey");
            var ruleSet = this.model;
            var runAsUserContext = ruleSet.getMetadata().getRunAsUserContext();
            var runAsUserMessage = "";

            if (!runAsUserContext || runAsUserContext.isRunAsCurrentUser()) {
                runAsUserMessage = AJS.I18n.getText('sd.automation.ruleset.run.as.user.label');
            } else {
                var runAsUser = this.projectRunAsUserSettings && this.projectRunAsUserSettings.getConfig() && this.projectRunAsUserSettings.getConfig().getUser();

                if (runAsUser) {
                    runAsUserMessage = AJS.I18n.getText('sd.automation.ruleset.run.as.project.default.label', runAsUser.getUserDisplayName());
                } else {
                    runAsUserMessage = AJS.I18n.getText('sd.automation.ruleset.run.as.project.default.notset.label');
                }
            }

            this.$el.html(this.template({
                ruleSet: this.model.toJSON(),
                projectKey: projectKey,
                runAsUserMessage: runAsUserMessage
            }));

            if (this.model.getValidation() && this.model.getValidation().hasErrors()) {
                this.renderError();
            }

            return this;
        },

        renderError: function() {
            var errors = this.model.getValidation().getErrors();
            var body = this.templateError({
               projectKey: AJS.Meta.get("projectKey"),
               id: this.model.getId(),
               errorMessages: errors
            });

            var warning = AJS.messages.warning({
                body: body,
                closeable: false
            });

            this.$('.rule-set-list-entry-error').empty();
            this.$('.rule-set-list-entry-error').append(warning);
        },

        editRuleSet: function(e) {
            e.preventDefault();
            var ruleSetId = this.model.getId();

            tracker.trackEvent("automation.list.ruleset.edit", {
                ruleSetId: ruleSetId
            });

            Navigator.navigateToFragment("ruleset/" + encodeURIComponent(ruleSetId));
        },

        viewAuditLog: function(e) {
            e.preventDefault();
            var ruleSetId = this.model.getId();

            tracker.trackEvent("automation.list.ruleset.viewlog", {
                ruleSetId: ruleSetId
            });

            Navigator.navigateToFragment("log/" + encodeURIComponent(ruleSetId));
        }
    });
});
