define("servicedesk/internal/agent/settings/automation/page/automation-audit-log-page/automation-audit-log-table-view", [
    "jquery",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/rule-set-execution-model",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics"
], function(
    $,
    Brace,
    RuleSetExecutionModel,
    tracker
) {
   
    return Brace.View.extend({
        template: ServiceDesk.Templates.Agent.Settings.automationAuditLogTable,
        detailDataTemplate: ServiceDesk.Templates.Agent.Settings.outComeDetail,
        
        events: {
            "click .audit-execution-more-link": "_showExecution",
            "click .audit-execution-less-link": "_hideExecution",
            "click .audit-execution-user-link": "_clickUser",
            "click .audit-execution-issue-link": "_clickIssue"
        },
        
        render: function() {
            this.$el.html(this.template({
                executions: this.model.getExecutions().toJSON()
            }));
            
            return this;
        },

        _showExecution: function(e) {
            e.preventDefault();

            var $showErrorLink = $(e.target);
            var executionId = this._getExecutionId($showErrorLink);

            this._triggerExecutionEvent("show", executionId);

            this.executionModel = new RuleSetExecutionModel({
                id: executionId
            });

            var $errorRow = this._getErrorRow(executionId);
            var $outcomeDetails = $errorRow.find(".outcome-details");
            var $dataRow = this._getDataRow(executionId);
            $errorRow.removeClass("hidden");
            $dataRow.addClass("no-bottom-border");

            // Only update the error message if it hasn't already been fetched
            if ($outcomeDetails.has("table").size() === 0) {
                this.executionModel.fetch().done(_.bind(function() {
                    $outcomeDetails.html(this.detailDataTemplate({
                        detailData: this.executionModel.toJSON(),
                        error: $dataRow.attr("data-outcome") === "ERROR"
                    }));
                }, this));
            }

            $showErrorLink.removeClass("audit-execution-more-link");
            $showErrorLink.addClass("audit-execution-less-link");
            $showErrorLink.text(AJS.I18n.getText("sd.automation.audit.log.table.action.show.less"));
        },

        _hideExecution: function(e) {
            e.preventDefault();

            var $hideErrorLink = $(e.target);
            var executionId = this._getExecutionId($hideErrorLink);

            this._triggerExecutionEvent("hide", executionId);

            $hideErrorLink.removeClass("audit-execution-less-link");
            $hideErrorLink.addClass("audit-execution-more-link");
            $hideErrorLink.text(AJS.I18n.getText("sd.automation.audit.log.table.action.show.more"));

            var $errorRow = this._getErrorRow(executionId);
            this._getDataRow(executionId).removeClass("no-bottom-border");
            $errorRow.addClass("hidden");
        },

        _clickUser: function(e) {
            var $userLink = $(e.target);
            var executionId = this._getExecutionId($userLink);

            this._triggerExecutionEvent("issue.clicked", executionId);
        },

        _clickIssue: function(e) {
            var $issueLink = $(e.target);
            var executionId = this._getExecutionId($issueLink);

            this._triggerExecutionEvent("user.clicked", executionId);
        },

        _getErrorRow: function(executionId) {
            return $(".audit-log-error-row[data-execution-id='" + executionId + "']");
        },

        _getDataRow: function(executionId) {
            return $(".audit-log-data-row[data-execution-id='" + executionId + "']");
        },

        _getExecutionId: function(showHideLink) {
            return showHideLink.parent().parent().data("execution-id");
        },

        _getClickedExecutionSummary: function(executionId) {
            return this.model.getExecutions().find(function(execution) {
                return execution.getId() === executionId;
            })
        },

        _triggerExecutionEvent: function(action, executionId) {
            var clickedExecutionSummary = this._getClickedExecutionSummary(executionId);
            tracker.trackEvent("automation.audit.execution." + action, {
                ruleSetId: this.model.getRuleId(),
                executionOutcome: clickedExecutionSummary.getOutcome().getOutcomeCode()
            });
        }
    });
});
