define("servicedesk/internal/agent/settings/automation/page/automation-audit-log-page/automation-audit-log-page-view", [
    "jquery",
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/page/automation-audit-log-page/automation-audit-log-table-view",
    "servicedesk/internal/agent/settings/automation/util/navigator/navigator",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics"
], function(
    $,
    Brace,
    RuleSetAuditLogTableView,
    Navigator,
    tracker
) {
    
    return Brace.View.extend({
        template: ServiceDesk.Templates.Agent.Settings.automationAuditLog,

        events: {
            "click .automation-list-breadcrumb": "_returnToList",
            "click .automation-edit-breadcrumb": "_editRuleSet",
            "click .aui-dropdown2-checkbox": "_updateTable",
            "change #automation-log-issue-filter": "_issueKeyFilterChanged",
            "click #show-executed-checkbox": "_hideSuccessfulExecutionsCheckboxClicked"
        },

        render: function () {
            const self = this;
            this.$el.html(this.template({
                ruleId: this.model.getRuleId(),
                ruleName: this.model.getRuleName(),
                executions: this.model.getExecutions().toJSON()
            }));

            AJS.$("#automation-log-issue-filter").auiSelect2({
                multiple: true,
                placeholder: AJS.I18n.getText("sd.automation.audit.log.filter.issue.placeholder"),
                ajax: {
                    url: self.model.getIssueKeysUrl(),
                    dataType: 'json',
                    delay: 250,
                    data: function (term) {
                        return {
                            searchQuery: term
                        }
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (value) {
                                return {
                                    id: value,
                                    text: value
                                };
                            })
                        };
                    },
                    cache: true
                }
            });

            this._updateTable();

            return this;
        },

        _returnToList: function (e) {
            e.preventDefault();

            tracker.trackEvent("automation.audit.breadcrumb.back", {
                ruleSetId: this.model.getRuleId()
            });

            Navigator.navigateToFragment("");
        },

        _editRuleSet: function (e) {
            e.preventDefault();

            tracker.trackEvent("automation.audit.breadcrumb.edit", {
                ruleSetId: this.model.getRuleId()
            });

            Navigator.navigateToFragment("ruleset/" + encodeURIComponent(this.model.getRuleId()))
        },

        _issueKeyFilterChanged: function () {
            this.model.setIssueKeyFilter($("#automation-log-issue-filter").val());
            this.model.fetch()
                .done(_.bind(function () {
                    this._updateTable();
                }, this));
        },

        _hideSuccessfulExecutionsCheckboxClicked: function(event) {
            this.model.setHideSuccessfulExecutions(!$('#show-executed-checkbox').prop('checked'));
            this.model.fetch()
                .done(_.bind(function () {
                    this._updateTable();
                }, this));
        },

        _updateTable: function () {
            const tableView = new RuleSetAuditLogTableView({
                model: this.model
            });
            this.$el.find(".audit-log-table-container").html(tableView.render().$el);
        }
    })
});
