define("servicedesk/internal/agent/settings/automation/model/when-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/model/component/when-handler-collection",
    "servicedesk/internal/agent/settings/automation/model/validation-model"
], function (
    Brace,
    WhenHandlerCollection,
    ValidationModel
    ) {

    return Brace.Model.extend({
        namedEvents: [
            "modelChanged"
        ],
        namedAttributes: {
            whenHandlers: WhenHandlerCollection,
            validation: ValidationModel
        },

        initialize: function() {
            this._bindEvents();
        },

        getCollection: function() {
            return this.getWhenHandlers();
        },

        getType: function() {
            return "whenHandler";
        },

        serialize: function() {
            var whenHandlers = this.getWhenHandlers() || new WhenHandlerCollection();

            return {
                whenHandlers: whenHandlers.map(function(whenHandler) {
                    return whenHandler.serialize();
                })
            }
        },

        validateStructure: function() {
            // This logic here must be the same as the structure check done on the server (see WhenValidator#validateSelf)
            var validation = this.getValidation() || new ValidationModel();

            var missingWhenHandlerError = AJS.I18n.getText("sd.automation.rule.set.error.rule.must.contain.an.when.handler");
            if (this.getWhenHandlers().isEmpty()) {
                validation.addGlobalError(missingWhenHandlerError);
            } else {
                validation.removeGlobalError(missingWhenHandlerError);
            }

            // We do not need to verify the when handlers as part of the structure validation.
        },

        isValid: function() {
            var isThisValid = !this.getValidation() || !this.getValidation().hasError();

            return isThisValid &&
                this.getWhenHandlers().every(function (whenHandler) {
                    return whenHandler.isValid();
                });
        },

        _checkStructureAndFireChangeEvent: function() {
            this.validateStructure();
            this.triggerModelChanged();
        },

        _bindEvents: function() {
            this.stopListening();

            this.listenTo(this, "change", _.bind(this._bindEvents, this));

            this.listenTo(this.getWhenHandlers(), "add remove", _.bind(this._checkStructureAndFireChangeEvent, this));
            this.listenTo(this.getWhenHandlers(), "modelChanged", this.triggerModelChanged);
        }
    });

});