define("servicedesk/internal/agent/settings/automation/model/rule-set-execution-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax",
    "servicedesk/internal/agent/settings/automation/model/rule-set-execution-ifthen-model",
    "servicedesk/internal/agent/settings/automation/model/rule-set-execution-outcome-detail-model"
], function(
    Brace,
    Ajax,
    IfThenModel,
    OutcomeDetailModel
) {
    var IfThenCollection = Brace.Collection.extend({
        model: IfThenModel
    });

    return Brace.Model.extend({
        namedAttributes: {
            outcomeMessage: String,
            whens: [OutcomeDetailModel],
            ifThens: IfThenCollection
        },
        
        fetch: function() {
            return Ajax
                .get(this.getUrl())
                .done(_.bind(function(data) {
                    this.set(data);
                }, this));
        },
        
        getUrl: function() {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/audit/execution/" + this.getId();
        }
    });
});
