define("servicedesk/internal/agent/settings/automation/model/metadata/run-as-user-context-model", [
    "automation/backbone-brace",
    "automation/underscore",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax",
    "servicedesk/internal/agent/settings/automation/model/metadata/user-context-model"
], function (
    Brace,
    _,
    Ajax,
    UserContextModel
    ) {

    return Brace.Model.extend({
        namedAttributes: {
            type: String,
            user: UserContextModel
        },

        isRunAsCurrentUser: function() {
            return _.isEqual(this.getType(), "currentUser");
        },

        serialize: function() {
            if (!this.getType())
            {
                return null;
            }

            // potentially we have a user
            var user = null;
            if (this.getUser()) {
                user = this.getUser().serialize();
            }

            return {
                type: this.getType(),
                user: user
            }
        }
    });
});