define("servicedesk/internal/agent/settings/automation/model/metadata/project-run-as-user-settings-model", [
    "automation/backbone-brace",
    "servicedesk/internal/agent/settings/automation/util/ajax/ajax",
    "servicedesk/internal/agent/settings/automation/model/metadata/run-as-user-context-model"
], function (
    Brace,
    Ajax,
    Model
    ) {

    return Brace.Model.extend({
        namedAttributes: {
            isSet: Boolean,
            isUpdated: Boolean,
            config: Model
        },

        save: function(projectKey, data) {
            this._pageReq = Ajax
                .put(this.getUrl(projectKey), data);

            return this._pageReq;
        },

        defaultToCurrentUserIfEmpty: function(projectKey) {
            this._pageReq = Ajax
                .put(this.defaultToCurrentUserIfEmptyUrl(projectKey));

            return this._pageReq;
        },

        serialize: function() {
            if (!this.getConfig()) {
                return null;
            }

            var user = null;
            if (this.getConfig().getUser()) {
                user = this.getConfig().getUser().serialize();
            }

            return {
                type: this.getConfig().getType(),
                user: user
            }
        },

        getUrl: function (projectKey) {
            return AJS.contextPath() + "/rest/servicedesk/automation/1/project/" + projectKey + "/runAsUser"
        },

        defaultToCurrentUserIfEmptyUrl: function(projectKey) {
            return this.getUrl(projectKey) + "/defaultToCurrentUserIfEmpty";
        }
    });
});