define("servicedesk/internal/agent/settings/automation/internal-automation-settings-app", [
    "jquery",
    "automation/backbone",
    "automation/underscore",
    "servicedesk/internal/agent/settings/automation/page/automation-list-page-module",
    "servicedesk/internal/agent/settings/automation/page/automation-rule-set-page-module",
    "servicedesk/internal/agent/settings/automation/page/automation-audit-log-page/automation-audit-log-page-module",
    "servicedesk/internal/agent/settings/automation/util/analytics/analytics",
    "servicedesk/internal/agent/settings/automation/util/navigator/navigator",
    "exports"
], function (
    $,
    Backbone,
    _,
    AutomationListModule,
    AutomationRuleSetModule,
    AutomationAuditLogModule,
    AutomationAnalytics,
    navigator,
    exports
) {

    var Router = Backbone.Router.extend({

        routes: {
            "" : "doList",
            "log/:entity": "doAuditLog",
            ":mode/:entity": "doRuleSet"
        },
        initialize: function () {
            this.listPage = new AutomationListModule();
            this.rulesetPage = new AutomationRuleSetModule();
            this.auditLogPage = new AutomationAuditLogModule();
            this.currentPage = null;
        },
        setElement: function ($el) {
            this.$el = $el;
        },
        doList: function () {
            this.currentPage = this.listPage;
            this.listPage.enable({}, this.$el);
        },
        doRuleSet: function (mode, entityId) {
            this.currentPage = this.rulesetPage;
            this.rulesetPage.enable({
                entityId: entityId,
                mode: mode
            }, this.$el);
        },
        doAuditLog: function(entityId) {
            this.currentPage = this.auditLogPage;
            this.auditLogPage.enable({
                entityId: entityId
            }, this.$el);
        }
    });

    var router = new Router();

    exports.start = function (options) {

        router.setElement(options.$el);

        Backbone.history.start({
            root: options.baseUrl,
            pushState: true
        });

        AutomationAnalytics.start({
            data: options.analyticsData,
            prefix: options.analyticsPrefix
        });

        //Set a call back to navigate to fragment outside automation
        navigator.setExternalNavigationCallback(options.externalNavigatorCallBack);

        return $.Deferred().resolve();
    };

    exports.stop = function () {
        Backbone.history.stop();
        AutomationAnalytics.stop();
    };

    exports.beforeNavigate = function () {
        if (router.currentPage && router.currentPage.beforeNavigate) {
            return router.currentPage.beforeNavigate();
        }

        return $.Deferred().resolve();
    }
});