define("servicedesk/internal/agent/settings/automation/feature/confirm-dialog/confirm-dialog", [
        "jquery",
        "automation/backbone-brace",
        "automation/underscore",
        "servicedesk/internal/agent/settings/automation/util/form-mixin/form-mixin",
        "servicedesk/internal/agent/settings/automation/util/trace/trace",
        "exports"
    ], function (
        $,
        Brace,
        _,
        FormMixin,
        trace,
        exports
    ) {

        exports.type = {
            SAVE_CHANGES: "SAVE_CHANGES",
            DELETE: "DELETE",
            CONFIRM: "CONFIRM",
            CUSTOM: "CUSTOM"
        };

        var View = Brace.View.extend({
            tagName: "section",
            className: "aui-layer aui-dialog2 aui-dialog2-medium sd-aui-dialog2",
            attributes: {
                role: "dialog"
            },
            template: Automation.Features.ConfirmationDialog.Templates.simple,
            mixins: [FormMixin],
            namedEvents: ["cancelled", "escaped", "submitCompleted"],

            events: {
                "click .js-confirm-action-button": "handleAction",
                "click .aui-dialog2-footer-actions .cancel": "onCancel",
                "keyup": "onKeyUp"
            },

            initialize: function (options) {
                this.mode = options.mode || this.Type.CUSTOM;
                this.action = options.action || $.noop;
                this.title = options.title || AJS.I18n.getText("sd-confirmation-dialog-default-title");
                this.explanation = options.explanation || AJS.I18n.getText("sd-confirmation-dialog-default-explanation");
                this.explanationContent = options.explanationContent;
                this.id = options.id || "sd-confirmation-dialog";
                this.button = options.button || AJS.I18n.getText('sd.common.words.confirm');
                this.primaryButton = options.primaryButton || false;
            },

            handleAction: function (e) {
                e.preventDefault();
                this.disableSubmit();
                this.showSpinner();

                this.action()
                    .done(_.bind(function(response) {
                        this.showSuccess(_.bind(function() {
                            this.triggerSubmitCompleted(response);
                        }, this));
                    }, this))
                    .fail(_.bind(function (errorCollection) {
                        this.applyErrors(this._getErrorCollection(errorCollection), ".confirm-dialog-errors", false, true);
                        this.enableSubmit();
                    }, this))
                    .always(_.bind(function() {
                        this.hideSpinner()
                    }, this))
    },

    //Copied from "servicedesk/util/ajax" so this component doesn't depend on JIRA
    _getErrorCollection: function(xhr) {
        var errorCollection;
        try {
            errorCollection = JSON.parse(xhr.responseText);
        } catch (e) {
            // no error collection so return generic error
            errorCollection = {
                errors: [
                    {errorMessage: AJS.I18n.getText("sd.error.ajax.general")}
                ]
            };
        }
        return errorCollection;
    },

    onCancel: function() {
        this.triggerCancelled();
    },

    onKeyUp: function(e) {
        if (e.keyCode === 27) {
            // if cancel was pressed
            this.triggerEscaped();
        }
    },

    _getFunctionOrValue: function(value) {
        return _.isFunction(value) ? value() : value;
    },

    render: function () {
        var title = this._getFunctionOrValue(this.title);
        var explanation = this._getFunctionOrValue(this.explanation);
        var explanationContent = this._getFunctionOrValue(this.explanationContent);
        var elId = this._getFunctionOrValue(this.id);
        var isPrimaryButton = true;
        var buttonText;

        if (this.mode === exports.type.CONFIRM) {
            buttonText = AJS.I18n.getText('sd.common.words.confirm');
        } else if (this.mode === exports.type.DELETE) {
            buttonText = AJS.I18n.getText('sd.common.words.delete');
        } else if (this.mode === exports.type.SAVE_CHANGES) {
            buttonText = AJS.I18n.getText('sd.common.words.save');
        } else if (this.mode === exports.type.CUSTOM) {
            buttonText = this.button;
            isPrimaryButton = this.primaryButton;
        }

        this.$el.html(AJS.$(this.template({
            title: title,
            explanation: explanation,
            explanationContent: explanationContent,
            button: buttonText,
            id: elId,
            isPrimaryButton: isPrimaryButton
        })));

        this.$el.attr("id", this.id);
        this.$el.attr('data-aui-remove-on-hide', true);
        this.$el.attr('data-aui-modal', true);

        trace("sd.confirm.dialog.rendered");
        return this.$el;
    }
});

    exports.create = function (options) {
        var view = new View(options);

        var dialog2 = new AJS.dialog2(view.render());

        // Workaround so we can listen to custom events using dialog2 "on" function
        var EVENT_PREFIX = "_aui-internal-layer-";

        view.listenTo(view, "submitCompleted", function (response) {
            dialog2.$el.trigger(EVENT_PREFIX + "submitCompleted", response);
            dialog2.hide();
            trace("sd.confirm.dialog.submit.completed");
        });

        view.listenTo(view, "cancelled", function() {
            dialog2.$el.trigger(EVENT_PREFIX + "cancel");
            dialog2.hide();
            if (options.onCancel) {
                options.onCancel();
            }
        });

        view.listenTo(view, "escaped", function() {
            dialog2.$el.trigger(EVENT_PREFIX + "escape");
            dialog2.hide();
            if (options.onCancel) {
                options.onCancel();
            }
        });

        return dialog2;
    };
});