/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.execution;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecutionSummary;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.execution.ExecutionOutcomeResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.execution.IfThenExecutionResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.execution.ExecutionOutcomeResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.execution.IfThenExecutionResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.execution.RuleExecutionResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.execution.RuleExecutionSummaryResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleExecutionResponseBuilder {
    private final ExecutionOutcomeResponseBuilder executionOutcomeResponseBuilder;
    private final IfThenExecutionResponseBuilder ifThenExecutionResponseBuilder;
    private final I18nHelper.BeanFactory i18nHelperFactory;

    @Autowired
    public RuleExecutionResponseBuilder(ExecutionOutcomeResponseBuilder executionOutcomeResponseBuilder, IfThenExecutionResponseBuilder ifThenExecutionResponseBuilder, I18nHelper.BeanFactory i18nHelperFactory) {
        this.executionOutcomeResponseBuilder = executionOutcomeResponseBuilder;
        this.ifThenExecutionResponseBuilder = ifThenExecutionResponseBuilder;
        this.i18nHelperFactory = i18nHelperFactory;
    }

    @Nonnull
    public RuleExecutionSummaryResponse buildSummary(@Nonnull ApplicationUser user, @Nonnull RuleExecutionSummary ruleExecutionSummary, @Nonnull DateTimeFormatter dateTimeFormatter) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ruleExecutionSummary", (Object)ruleExecutionSummary);
        ExecutionOutcomeResponse executionOutcomeResponse = this.executionOutcomeResponseBuilder.buildForRule(user, ruleExecutionSummary.getResult());
        return new RuleExecutionSummaryResponse(ruleExecutionSummary.getId(), ruleExecutionSummary.getRuleId(), (String)ruleExecutionSummary.getIssueKey().getOrNull(), ruleExecutionSummary.getStartTime(), ruleExecutionSummary.getFinishTime(), this.formatDate(ruleExecutionSummary.getStartTime(), dateTimeFormatter), (String)ruleExecutionSummary.getExecutedBy().getOrNull(), executionOutcomeResponse);
    }

    @Nonnull
    public RuleExecutionResponse build(final @Nonnull ApplicationUser user, @Nonnull RuleExecution ruleExecution) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ruleExecutionSummary", (Object)ruleExecution);
        ExecutionOutcomeResponse executionOutcomeResponse = this.executionOutcomeResponseBuilder.buildForRule(user, ruleExecution.getResult());
        List ifThenExecutionResponses = Lists.transform(ruleExecution.getIfThenExecutions(), (Function)new Function<IfThenExecution, IfThenExecutionResponse>(){

            @Nullable
            public IfThenExecutionResponse apply(IfThenExecution ifThenExecution) {
                return RuleExecutionResponseBuilder.this.ifThenExecutionResponseBuilder.build(user, ifThenExecution);
            }
        });
        RuleMessage msg = (RuleMessage)ruleExecution.getMessage().getOrNull();
        return new RuleExecutionResponse(ruleExecution.getId(), ruleExecution.getRuleId(), ruleExecution.getRuleName(), (String)this.getNonExecutionRootCause(user, ruleExecution).getOrNull(), ruleExecution.getStartTime(), ruleExecution.getFinishTime(), (String)ruleExecution.getExecutedBy().getOrNull(), executionOutcomeResponse, ifThenExecutionResponses, null != msg ? msg.getAllValues() : null);
    }

    private Option<String> getNonExecutionRootCause(ApplicationUser user, RuleExecution ruleExecution) {
        I18nHelper i18n = this.i18nHelperFactory.getInstance(user);
        if (ruleExecution.getResult().getOutcome() == RuleExecution.Outcome.ERROR) {
            for (IfThenExecution ifThenExecution : ruleExecution.getIfThenExecutions()) {
                for (IfConditionExecution ifConditionExecution : this.getIfConditionExecutions(ifThenExecution)) {
                    if (ifConditionExecution.getResult().getOutcome() != IfConditionExecution.Outcome.ERROR) continue;
                    return Option.some((Object)i18n.getText("sd.automation.execution.outcome.root.if.error", this.extractModuleName(ifConditionExecution.getModuleKey()), (String)ifConditionExecution.getResult().getMessage().getOrElse((Object)i18n.getText("sd.automation.execution.outcome.root.error.unknown"))));
                }
                for (ThenActionExecution thenActionExecution : this.getThenActionExecutions(ifThenExecution)) {
                    if (thenActionExecution.getResult().getOutcome() != ThenActionExecution.Outcome.ERROR) continue;
                    return Option.some((Object)i18n.getText("sd.automation.execution.outcome.root.then.error", this.extractModuleName(thenActionExecution.getModuleKey()), (String)thenActionExecution.getResult().getMessage().getOrElse((Object)i18n.getText("sd.automation.execution.outcome.root.error.unknown"))));
                }
            }
        } else if (ruleExecution.getResult().getOutcome() == RuleExecution.Outcome.NOT_EXECUTED) {
            String nonExecutionMessage = i18n.getText("sd.automation.execution.outcome.root.if.nonexecution.default");
            for (IfThenExecution ifThenExecution : ruleExecution.getIfThenExecutions()) {
                for (IfConditionExecution ifConditionExecution : this.getIfConditionExecutions(ifThenExecution)) {
                    if (ifConditionExecution.getResult().getOutcome() != IfConditionExecution.Outcome.NOT_MET) continue;
                    nonExecutionMessage = i18n.getText("sd.automation.execution.outcome.root.if.nonexecution", this.extractModuleName(ifConditionExecution.getModuleKey()));
                }
            }
            return Option.some((Object)nonExecutionMessage);
        }
        return Option.none();
    }

    private List<IfConditionExecution> getIfConditionExecutions(IfThenExecution ifThenExecution) {
        return (List)ifThenExecution.getIfExecution().map(IfExecution::getIfConditionExecutions).getOrElse(new ArrayList());
    }

    private List<ThenActionExecution> getThenActionExecutions(IfThenExecution ifThenExecution) {
        return (List)ifThenExecution.getThenExecution().map(ThenExecution::getThenActionExecutions).getOrElse(new ArrayList());
    }

    private String extractModuleName(String fullyQualifiedModuleKey) {
        if (fullyQualifiedModuleKey.contains(":")) {
            return fullyQualifiedModuleKey.split(":")[1];
        }
        return fullyQualifiedModuleKey;
    }

    private String formatDate(DateTime date, DateTimeFormatter formatter) {
        return ZonedDateTime.ofInstant(date.toDate().toInstant(), formatter.getZone()).format(formatter);
    }
}

