/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.execution;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionResult;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.execution.ExecutionOutcomeResponse;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutionOutcomeResponseBuilder {
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public ExecutionOutcomeResponseBuilder(I18nHelper.BeanFactory i18nFactory) {
        this.i18nFactory = i18nFactory;
    }

    @Nonnull
    public ExecutionOutcomeResponse buildForRule(@Nonnull ApplicationUser user, @Nonnull ExecutionResult<RuleExecution.Outcome> executionResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"executionResult", executionResult);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        RuleExecution.Outcome outcome = executionResult.getOutcome();
        Boolean hasError = outcome == RuleExecution.Outcome.ERROR;
        String message = (String)executionResult.getMessage().getOrNull();
        String i18nKeyOutcome = this.getI18nKeyFromRuleOutcome(outcome);
        String outcomeAsText = i18nHelper.getText(i18nKeyOutcome);
        return new ExecutionOutcomeResponse(outcomeAsText, outcome.toString(), message, hasError);
    }

    @Nonnull
    public ExecutionOutcomeResponse buildForIfCondition(@Nonnull ApplicationUser user, @Nonnull ExecutionResult<IfConditionExecution.Outcome> executionResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"executionResult", executionResult);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        IfConditionExecution.Outcome outcome = executionResult.getOutcome();
        Boolean hasError = outcome == IfConditionExecution.Outcome.ERROR;
        String message = (String)executionResult.getMessage().getOrNull();
        String i18nKeyOutcome = this.getI18nKeyFromIfConditionOutcome(outcome);
        String outcomeAsText = i18nHelper.getText(i18nKeyOutcome);
        return new ExecutionOutcomeResponse(outcomeAsText, outcome.toString(), message, hasError);
    }

    @Nonnull
    public ExecutionOutcomeResponse buildForThenAction(@Nonnull ApplicationUser user, @Nonnull ExecutionResult<ThenActionExecution.Outcome> executionResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"executionResult", executionResult);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        ThenActionExecution.Outcome outcome = executionResult.getOutcome();
        Boolean hasError = outcome == ThenActionExecution.Outcome.ERROR;
        String message = (String)executionResult.getMessage().getOrNull();
        String i18nKeyOutcome = this.getI18nKeyFromThenActionOutcome(outcome);
        String outcomeAsText = i18nHelper.getText(i18nKeyOutcome);
        return new ExecutionOutcomeResponse(outcomeAsText, outcome.toString(), message, hasError);
    }

    @Nonnull
    public ExecutionOutcomeResponse buildForThen(@Nonnull ApplicationUser user, @Nonnull ExecutionResult<ThenExecution.Outcome> executionResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"executionResult", executionResult);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        ThenExecution.Outcome outcome = executionResult.getOutcome();
        Boolean hasError = outcome == ThenExecution.Outcome.ERROR || outcome == ThenExecution.Outcome.SOME_ACTIONS_INVOKED;
        String message = (String)executionResult.getMessage().getOrNull();
        String i18nKeyOutcome = this.getI18nKeyFromThenOutcome(outcome);
        String outcomeAsText = i18nHelper.getText(i18nKeyOutcome);
        return new ExecutionOutcomeResponse(outcomeAsText, outcome.toString(), message, hasError);
    }

    @Nonnull
    public ExecutionOutcomeResponse buildForIf(@Nonnull ApplicationUser user, @Nonnull ExecutionResult<IfExecution.Outcome> executionResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"executionResult", executionResult);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        IfExecution.Outcome outcome = executionResult.getOutcome();
        Boolean hasError = outcome == IfExecution.Outcome.ERROR;
        String message = (String)executionResult.getMessage().getOrNull();
        String i18nKeyOutcome = this.getI18nKeyFromIfOutcome(outcome);
        String outcomeAsText = i18nHelper.getText(i18nKeyOutcome);
        return new ExecutionOutcomeResponse(outcomeAsText, outcome.toString(), message, hasError);
    }

    @Nonnull
    public ExecutionOutcomeResponse buildForIfThen(@Nonnull ApplicationUser user, @Nonnull ExecutionResult<IfThenExecution.Outcome> executionResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"executionResult", executionResult);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        IfThenExecution.Outcome outcome = executionResult.getOutcome();
        Boolean hasError = outcome == IfThenExecution.Outcome.SOME_ACTIONS_INVOKED || outcome == IfThenExecution.Outcome.ERROR;
        String message = (String)executionResult.getMessage().getOrNull();
        String i18nKeyOutcome = this.getI18nKeyFromIfThenOutcome(outcome);
        String outcomeAsText = i18nHelper.getText(i18nKeyOutcome);
        return new ExecutionOutcomeResponse(outcomeAsText, outcome.toString(), message, hasError);
    }

    private String getI18nKeyFromIfThenOutcome(IfThenExecution.Outcome outcome) {
        switch (outcome) {
            case ALL_ACTIONS_INVOKED: {
                return "sd.automation.execution.outcome.if.then.actions.complete";
            }
            case IF_DID_NOT_PASS: {
                return "sd.automation.execution.outcome.if.then.conditions.not.met";
            }
            case SOME_ACTIONS_INVOKED: {
                return "sd.automation.execution.outcome.if.then.actions.partial";
            }
            case ERROR: {
                return "sd.automation.execution.outcome.if.then.error";
            }
        }
        return "sd.automation.execution.outcome.if.then.unknown";
    }

    private String getI18nKeyFromIfOutcome(IfExecution.Outcome outcome) {
        switch (outcome) {
            case ALL_CONDITIONS_MET: {
                return "sd.automation.execution.outcome.if.met";
            }
            case NOT_ALL_CONDITIONS_MET: {
                return "sd.automation.execution.outcome.if.met.partial";
            }
            case ERROR: {
                return "sd.automation.execution.outcome.if.error";
            }
        }
        return "sd.automation.execution.outcome.if.unknown";
    }

    private String getI18nKeyFromThenOutcome(ThenExecution.Outcome outcome) {
        switch (outcome) {
            case ALL_ACTIONS_INVOKED: {
                return "sd.automation.execution.outcome.then.success";
            }
            case SOME_ACTIONS_INVOKED: {
                return "sd.automation.execution.outcome.then.success.partial";
            }
        }
        return "sd.automation.execution.outcome.then.unknown";
    }

    private String getI18nKeyFromThenActionOutcome(ThenActionExecution.Outcome outcome) {
        switch (outcome) {
            case SUCCESS: {
                return "sd.automation.execution.outcome.then.action.success";
            }
            case ERROR: {
                return "sd.automation.execution.outcome.then.action.error";
            }
        }
        return "sd.automation.execution.outcome.then.action.unknown";
    }

    private String getI18nKeyFromIfConditionOutcome(IfConditionExecution.Outcome outcome) {
        switch (outcome) {
            case MET: {
                return "sd.automation.execution.outcome.if.condition.met";
            }
            case NOT_MET: {
                return "sd.automation.execution.outcome.if.condition.not.met";
            }
            case ERROR: {
                return "sd.automation.execution.outcome.if.condition.error";
            }
        }
        return "sd.automation.execution.outcome.if.condition.unknown";
    }

    private String getI18nKeyFromRuleOutcome(RuleExecution.Outcome outcome) {
        switch (outcome) {
            case EXECUTED: {
                return "sd.automation.execution.outcome.rule.success";
            }
            case ERROR: {
                return "sd.automation.execution.outcome.rule.error";
            }
            case NOT_EXECUTED: {
                return "sd.automation.execution.outcome.rule.not.executed";
            }
        }
        return "sd.automation.execution.outcome.rule.unknown";
    }
}

