/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.ozymandias.error.ModuleNotFoundError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerData;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerModuleData;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.WhenHandlerResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.WhenHandlerSummaryResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.WhenHandlerModuleDataListResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.WhenHandlerModuleDataResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhenHandlerResponseBuilder {
    private static final String HELP_ICON_CLASS = "help";
    private static final String WARNING_ICON_CLASS = "warning";
    private final WhenHandlerManager whenHandlerManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ValidationResponseBuilder validationResponseBuilder;

    @Autowired
    public WhenHandlerResponseBuilder(@Nonnull WhenHandlerManager whenHandlerManager, @Nonnull ValidationResponseBuilder validationResponseBuilder, @Nonnull I18nHelper.BeanFactory i18nFactory) {
        Assertions.notNull((String)"whenHandlerManager", (Object)whenHandlerManager);
        Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        Assertions.notNull((String)"validationResponseBuilder", (Object)validationResponseBuilder);
        this.whenHandlerManager = whenHandlerManager;
        this.i18nFactory = i18nFactory;
        this.validationResponseBuilder = validationResponseBuilder;
    }

    public WhenHandlerResponse buildWhenHandler(@Nonnull ApplicationUser user, @Nonnull WhenHandlerConfiguration configuration, @Nonnull ValidationResult validationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configuration", (Object)configuration);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        String moduleKey = configuration.getModuleKey();
        ConfigurationData configurationData = configuration.getData();
        return this.getWhenHandlerResponse(user, configurationData, validationResult, moduleKey);
    }

    public WhenHandlerResponse buildWhenHandlerInput(@Nonnull ApplicationUser user, @Nonnull ComponentConfigurationInputImpl configuration, @Nonnull ValidationResult validationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configuration", (Object)configuration);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        ConfigurationData configurationData = configuration.getData();
        Option<String> moduleKeyOption = configuration.getModuleKey();
        if (moduleKeyOption.isEmpty()) {
            return this.getNoModuleKeyResponse(user, validationResult, configurationData);
        }
        String moduleKey = (String)moduleKeyOption.get();
        return this.getWhenHandlerResponse(user, configurationData, validationResult, moduleKey);
    }

    public WhenHandlerSummaryResponse buildWhenHandlerSummaryResponse(@Nonnull ApplicationUser user, @Nonnull WhenHandlerConfiguration configuration) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configuration", (Object)configuration);
        String moduleKey = configuration.getModuleKey();
        ConfigurationData configurationData = configuration.getData();
        Either<? extends ModuleAccessError, WhenHandlerData> whenHandlerDataResult = this.whenHandlerManager.getConfiguredWhenHandlerData(user, moduleKey, configurationData);
        String name = null;
        String iconClass = null;
        if (whenHandlerDataResult.isLeft()) {
            ModuleAccessError moduleAccessError = (ModuleAccessError)whenHandlerDataResult.left().get();
            if (moduleAccessError instanceof ModuleNotFoundError) {
                iconClass = HELP_ICON_CLASS;
                name = this.i18nFactory.getInstance(user).getText("sd.automation.module.access.error.module.unknown", moduleKey);
            } else {
                iconClass = WARNING_ICON_CLASS;
                name = this.i18nFactory.getInstance(user).getText("sd.automation.module.access.error.module.invalid", moduleKey);
            }
        } else {
            WhenHandlerData whenHandlerData = (WhenHandlerData)whenHandlerDataResult.right().get();
            name = whenHandlerData.getWhenHandlerDisplayData().getName();
            iconClass = (String)whenHandlerData.getWhenHandlerModuleData().getIconClass().getOrNull();
        }
        return new WhenHandlerSummaryResponse(name, iconClass);
    }

    private WhenHandlerResponse getWhenHandlerResponse(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData, @Nonnull ValidationResult validationResult, @Nonnull String moduleKey) {
        Either<? extends ModuleAccessError, WhenHandlerData> whenHandlerDataResult = this.whenHandlerManager.getConfiguredWhenHandlerData(user, moduleKey, configurationData);
        if (whenHandlerDataResult.isLeft()) {
            ModuleAccessError moduleAccessError = (ModuleAccessError)whenHandlerDataResult.left().get();
            if (moduleAccessError instanceof ModuleNotFoundError) {
                return this.getModuleNotFoundResponse(user, moduleKey, validationResult, configurationData);
            }
            return this.getModuleInvalidError(user, moduleKey, validationResult, configurationData);
        }
        WhenHandlerData whenHandlerData = (WhenHandlerData)whenHandlerDataResult.right().get();
        WhenHandlerModuleData whenHandlerModuleData = whenHandlerData.getWhenHandlerModuleData();
        WhenHandlerDisplayData whenHandlerDisplayData = whenHandlerData.getWhenHandlerDisplayData();
        return this.from(user, whenHandlerModuleData, whenHandlerDisplayData, validationResult, configurationData);
    }

    private WhenHandlerResponse getNoModuleKeyResponse(ApplicationUser user, ValidationResult validationResult, ConfigurationData configurationData) {
        return this.getModuleNotFoundResponse(user, "", validationResult, configurationData);
    }

    private WhenHandlerResponse getModuleNotFoundResponse(ApplicationUser user, String moduleKey, ValidationResult validationResult, ConfigurationData configurationData) {
        String unknownModuleName = this.i18nFactory.getInstance(user).getText("sd.automation.module.access.error.module.unknown", moduleKey);
        WhenHandlerModuleData whenHandlerModuleData = new WhenHandlerModuleData(moduleKey, unknownModuleName, (Option<String>)Option.some((Object)HELP_ICON_CLASS), (Option<String>)Option.none(), Sets.newHashSet(), false);
        WhenHandlerDisplayData whenHandlerDisplayData = new WhenHandlerDisplayData(unknownModuleName, (Option<String>)Option.none());
        return this.from(user, whenHandlerModuleData, whenHandlerDisplayData, validationResult, configurationData);
    }

    private WhenHandlerResponse getModuleInvalidError(ApplicationUser user, String moduleKey, ValidationResult validationResult, ConfigurationData configurationData) {
        String invalidModuleName = this.i18nFactory.getInstance(user).getText("sd.automation.module.access.error.module.invalid", moduleKey);
        WhenHandlerModuleData whenHandlerModuleData = new WhenHandlerModuleData(moduleKey, invalidModuleName, (Option<String>)Option.some((Object)WARNING_ICON_CLASS), (Option<String>)Option.none(), Sets.newHashSet(), false);
        WhenHandlerDisplayData whenHandlerDisplayData = new WhenHandlerDisplayData(invalidModuleName, (Option<String>)Option.none());
        return this.from(user, whenHandlerModuleData, whenHandlerDisplayData, validationResult, configurationData);
    }

    public WhenHandlerModuleDataListResponse buildWhenHandlerModuleList() {
        List<WhenHandlerModuleData> whenHandlerModuleDataList = this.whenHandlerManager.getWhenHandlerModuleDataList();
        ArrayList responses = Lists.newArrayList();
        for (WhenHandlerModuleData data : whenHandlerModuleDataList) {
            responses.add(this.from(data));
        }
        return new WhenHandlerModuleDataListResponse(responses);
    }

    private WhenHandlerModuleDataResponse from(WhenHandlerModuleData whenHandlerModuleData) {
        return new WhenHandlerModuleDataResponse(whenHandlerModuleData.getModuleKey(), whenHandlerModuleData.getName(), (String)whenHandlerModuleData.getIconClass().getOrNull(), (String)whenHandlerModuleData.getWebFormModule().getOrNull(), whenHandlerModuleData.getProvides(), whenHandlerModuleData.isUnique());
    }

    private WhenHandlerResponse from(ApplicationUser user, WhenHandlerModuleData whenHandlerModuleData, WhenHandlerDisplayData whenHandlerDisplayData, ValidationResult validationResult, ConfigurationData configurationData) {
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, validationResult);
        return new WhenHandlerResponse(whenHandlerModuleData.getModuleKey(), whenHandlerDisplayData.getName(), (String)whenHandlerDisplayData.getLabel().getOrNull(), (String)whenHandlerModuleData.getIconClass().getOrNull(), (String)whenHandlerModuleData.getWebFormModule().getOrNull(), configurationData.getAll(), validationResponse, whenHandlerModuleData.getProvides(), whenHandlerModuleData.isUnique());
    }
}

