/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.ozymandias.error.ModuleNotFoundError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.If;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Then;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.When;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.IfThenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.IfValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleSetValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ThenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.WhenValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionData;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionData;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerData;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerManager;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationSummaryResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidationResponseBuilder {
    private final WhenHandlerManager whenHandlerManager;
    private final IfConditionManager ifConditionManager;
    private final ThenActionManager thenActionManager;
    private final I18nHelper i18nHelper;

    @Autowired
    public ValidationResponseBuilder(WhenHandlerManager whenHandlerManager, IfConditionManager ifConditionManager, ThenActionManager thenActionManager, I18nHelper i18nHelper) {
        this.whenHandlerManager = whenHandlerManager;
        this.ifConditionManager = ifConditionManager;
        this.thenActionManager = thenActionManager;
        this.i18nHelper = i18nHelper;
    }

    public ValidationResponse build(@Nonnull ApplicationUser user, @Nonnull ValidationResult validationResult) {
        ValidationResult.ValidationErrors errors = validationResult.getErrors();
        return new ValidationResponse(errors.getComponentErrors(), errors.getFieldErrors());
    }

    public ValidationSummaryResponse buildSummaryForRuleSet(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet, @Nonnull RuleSetValidationResult ruleSetValidationResult) {
        HashSet errors = Sets.newHashSet(this.flattenValidationResult(ruleSetValidationResult.getRuleSetValidationResult()));
        List ruleValidationResults = ruleSetValidationResult.getRuleValidationResults();
        for (int i = 0; i < ruleSet.getRules().size(); ++i) {
            Rule rule = (Rule)ruleSet.getRules().get(i);
            RuleValidationResult ruleValidationResult = (RuleValidationResult)ruleValidationResults.get(i);
            Set<String> ruleErrors = this.flattenRuleValidationErrors(user, rule, ruleValidationResult);
            errors.addAll(ruleErrors);
        }
        return new ValidationSummaryResponse(errors);
    }

    private Set<String> flattenRuleValidationErrors(@Nonnull ApplicationUser user, @Nonnull Rule rule, @Nonnull RuleValidationResult ruleValidationResult) {
        Set<String> errors = this.flattenValidationResult(ruleValidationResult.getRuleValidationResult());
        List<String> ifThenErrors = this.flattenIfThenValidationResults(user, rule.getIfThens(), ruleValidationResult.getIfThenValidationResults());
        errors.addAll(ifThenErrors);
        Set<String> whenErrors = this.flattenWhenValidationResults(user, rule.getWhen(), ruleValidationResult.getWhenValidationResults());
        errors.addAll(whenErrors);
        return errors;
    }

    private List<String> flattenIfThenValidationResults(@Nonnull ApplicationUser user, @Nonnull List<IfThen> ifThens, @Nonnull List<IfThenValidationResult> ifThenValidationResults) {
        ArrayList errors = Lists.newArrayList();
        for (IfThenValidationResult ifThenValidationResult : ifThenValidationResults) {
            errors.addAll(this.flattenValidationResult(ifThenValidationResult.getIfThenValidationResult()));
        }
        for (int i = 0; i < ifThenValidationResults.size(); ++i) {
            IfThenValidationResult ifThenValidationResult;
            ifThenValidationResult = ifThenValidationResults.get(i);
            IfThen ifThen = ifThens.get(i);
            errors.addAll(this.flattenIfValidationResults(user, ifThen.getIf(), ifThenValidationResult.getIfValidationResults()));
            errors.addAll(this.flattenThenValidationResults(user, ifThen.getThen(), ifThenValidationResult.getThenValidationResults()));
        }
        return errors;
    }

    private Set<String> flattenThenValidationResults(@Nonnull ApplicationUser user, @Nonnull Then then, @Nonnull ThenValidationResult thenValidationResult) {
        Set<String> errors = this.flattenValidationResult(thenValidationResult.getThenValidationResult());
        List thenActionValidationResults = thenValidationResult.getThenActionValidationResults();
        for (int i = 0; i < thenActionValidationResults.size(); ++i) {
            ValidationResult thenActionErrors = (ValidationResult)thenActionValidationResults.get(i);
            ThenActionConfiguration thenActionConfiguration = (ThenActionConfiguration)then.getThenActionConfigurations().get(i);
            if (thenActionErrors.isPassed()) continue;
            Either<? extends ModuleAccessError, ThenActionData> thenActionDataEither = this.thenActionManager.getConfiguredThenActionData(user, thenActionConfiguration.getModuleKey(), thenActionConfiguration.getData());
            if (thenActionDataEither.isLeft()) {
                ModuleAccessError moduleAccessError = (ModuleAccessError)thenActionDataEither.left().get();
                if (moduleAccessError instanceof ModuleNotFoundError) {
                    errors.add(this.i18nHelper.getText("sd.automation.rule.set.list.missing.module.then"));
                    continue;
                }
                errors.add(this.i18nHelper.getText("sd.automation.rule.set.list.invalid.module.then"));
                continue;
            }
            ThenActionData thenActionData = (ThenActionData)thenActionDataEither.right().get();
            String errorPrefix = this.i18nHelper.getText("sd.automation.rule.set.list.error.prefix.then", thenActionData.getThenActionDisplayData().getName());
            errors.addAll(this.getErrorStringFromValidationResult(errorPrefix, thenActionErrors));
        }
        return errors;
    }

    private Set<String> flattenWhenValidationResults(@Nonnull ApplicationUser user, @Nonnull When when, @Nonnull WhenValidationResult whenValidationResult) {
        Set<String> errors = this.flattenValidationResult(whenValidationResult.getWhenValidationResult());
        List whenHandlerValidationResults = whenValidationResult.getWhenHandlerResults();
        for (int i = 0; i < whenHandlerValidationResults.size(); ++i) {
            ValidationResult whenHandlerErrors = (ValidationResult)whenHandlerValidationResults.get(i);
            WhenHandlerConfiguration whenHandlerConfiguration = (WhenHandlerConfiguration)when.getWhenHandlerConfigurations().get(i);
            if (whenHandlerErrors.isPassed()) continue;
            Either<? extends ModuleAccessError, WhenHandlerData> whenHandlerDataEither = this.whenHandlerManager.getConfiguredWhenHandlerData(user, whenHandlerConfiguration.getModuleKey(), whenHandlerConfiguration.getData());
            if (whenHandlerDataEither.isLeft()) {
                ModuleAccessError moduleAccessError = (ModuleAccessError)whenHandlerDataEither.left().get();
                if (moduleAccessError instanceof ModuleNotFoundError) {
                    errors.add(this.i18nHelper.getText("sd.automation.rule.set.list.missing.module.when"));
                    continue;
                }
                errors.add(this.i18nHelper.getText("sd.automation.rule.set.list.invalid.module.when"));
                continue;
            }
            WhenHandlerData whenHandlerData = (WhenHandlerData)whenHandlerDataEither.right().get();
            String errorPrefix = this.i18nHelper.getText("sd.automation.rule.set.list.error.prefix.when", whenHandlerData.getWhenHandlerDisplayData().getName());
            errors.addAll(this.getErrorStringFromValidationResult(errorPrefix, whenHandlerErrors));
        }
        return errors;
    }

    private Set<String> flattenIfValidationResults(@Nonnull ApplicationUser user, @Nonnull If ruleIf, @Nonnull IfValidationResult IfValidationResult2) {
        Set<String> errors = this.flattenValidationResult(IfValidationResult2.getIfValidationResult());
        List ifConditionValidationResults = IfValidationResult2.getIfConditionValidationResult();
        for (int i = 0; i < ifConditionValidationResults.size(); ++i) {
            ValidationResult ifConditionErrors = (ValidationResult)ifConditionValidationResults.get(i);
            IfConditionConfiguration ifConditionConfiguration = (IfConditionConfiguration)ruleIf.getIfConditionConfigurations().get(i);
            if (ifConditionErrors.isPassed()) continue;
            Either<? extends ModuleAccessError, IfConditionData> ifConditionDataEither = this.ifConditionManager.getConfiguredIfConditionData(user, ifConditionConfiguration.getModuleKey(), ifConditionConfiguration.getData());
            if (ifConditionDataEither.isLeft()) {
                ModuleAccessError moduleAccessError = (ModuleAccessError)ifConditionDataEither.left().get();
                if (moduleAccessError instanceof ModuleNotFoundError) {
                    errors.add(this.i18nHelper.getText("sd.automation.rule.set.list.missing.module.if"));
                    continue;
                }
                errors.add(this.i18nHelper.getText("sd.automation.rule.set.list.invalid.module.if"));
                continue;
            }
            IfConditionData ifConditionData = (IfConditionData)ifConditionDataEither.right().get();
            String errorPrefix = this.i18nHelper.getText("sd.automation.rule.set.list.error.prefix.if", ifConditionData.getIfConditionDisplayData().getName());
            errors.addAll(this.getErrorStringFromValidationResult(errorPrefix, ifConditionErrors));
        }
        return errors;
    }

    private Set<String> getErrorStringFromValidationResult(String errorPrefix, ValidationResult validationResult) {
        HashSet errors = Sets.newHashSet();
        Set<String> flattenValidationResult = this.flattenValidationResult(validationResult);
        for (String errorMessage : flattenValidationResult) {
            errors.add(errorPrefix + " " + errorMessage);
        }
        return errors;
    }

    private Set<String> flattenValidationResult(@Nonnull ValidationResult validationResult) {
        ValidationResult.ValidationErrors validationErrors = validationResult.getErrors();
        HashSet errors = Sets.newHashSet();
        errors.addAll(validationErrors.getComponentErrors());
        errors.addAll(this.flatten(validationErrors.getFieldErrors().values()));
        return errors;
    }

    private Set<String> flatten(@Nonnull Iterable<List<String>> listOfLists) {
        HashSet flattenedList = Sets.newHashSet();
        for (List<String> innerList : listOfLists) {
            flattenedList.addAll(innerList);
        }
        return flattenedList;
    }
}

