/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Then;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ThenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ThenInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ThenActionResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ThenResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThenResponseBuilder {
    private final ThenActionResponseBuilder thenActionResponseBuilder;
    private final ValidationResponseBuilder validationResponseBuilder;

    @Autowired
    public ThenResponseBuilder(@Nonnull ThenActionResponseBuilder thenActionResponseBuilder, @Nonnull ValidationResponseBuilder validationResponseBuilder) {
        Assertions.notNull((String)"thenActionResponseBuilder", (Object)thenActionResponseBuilder);
        Assertions.notNull((String)"validationResponseBuilder", (Object)validationResponseBuilder);
        this.validationResponseBuilder = validationResponseBuilder;
        this.thenActionResponseBuilder = thenActionResponseBuilder;
    }

    public ThenResponse build(@Nonnull ApplicationUser user, @Nonnull Then then, @Nonnull ThenValidationResult thenValidationResult) {
        List thenActionConfigurations = then.getThenActionConfigurations();
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, thenValidationResult.getThenValidationResult());
        ArrayList thenActionResponses = Lists.newArrayList();
        for (int i = 0; i < thenActionConfigurations.size(); ++i) {
            ThenActionConfiguration thenActionConfiguration = (ThenActionConfiguration)thenActionConfigurations.get(i);
            ValidationResult validationResult = (ValidationResult)thenValidationResult.getThenActionValidationResults().get(i);
            thenActionResponses.add(this.thenActionResponseBuilder.buildThenAction(user, thenActionConfiguration, validationResult));
        }
        return new ThenResponse(thenActionResponses, validationResponse);
    }

    public ThenResponse buildFromInput(@Nonnull ApplicationUser user, @Nonnull ThenInputImpl thenInputImpl, @Nonnull ThenValidationResult thenValidationResult) {
        List<ComponentConfigurationInputImpl> thenActionConfigurations = thenInputImpl.getThenActionConfigurationInputs();
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, thenValidationResult.getThenValidationResult());
        ArrayList thenActionResponses = Lists.newArrayList();
        for (int i = 0; i < thenActionConfigurations.size(); ++i) {
            ComponentConfigurationInputImpl thenActionConfiguration = thenActionConfigurations.get(i);
            ValidationResult validationResult = (ValidationResult)thenValidationResult.getThenActionValidationResults().get(i);
            thenActionResponses.add(this.thenActionResponseBuilder.buildThenActionInput(user, thenActionConfiguration, validationResult));
        }
        return new ThenResponse(thenActionResponses, validationResponse);
    }
}

