/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.ozymandias.error.ModuleNotFoundError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionData;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionModuleData;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ThenActionResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.ThenActionModuleDataListResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.ThenActionModuleDataResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThenActionResponseBuilder {
    private static final String HELP_ICON_CLASS = "help";
    private static final String WARNING_ICON_CLASS = "warning";
    private final ValidationResponseBuilder validationResponseBuilder;
    private final ThenActionManager thenActionManager;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public ThenActionResponseBuilder(@Nonnull ValidationResponseBuilder validationResponseBuilder, @Nonnull ThenActionManager thenActionManager, @Nonnull I18nHelper.BeanFactory i18nFactory) {
        Assertions.notNull((String)"validationResponseBuilder", (Object)validationResponseBuilder);
        Assertions.notNull((String)"thenActionManager", (Object)thenActionManager);
        Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.validationResponseBuilder = validationResponseBuilder;
        this.thenActionManager = thenActionManager;
        this.i18nFactory = i18nFactory;
    }

    public ThenActionResponse buildThenAction(@Nonnull ApplicationUser user, @Nonnull ThenActionConfiguration configuration, @Nonnull ValidationResult validationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configuration", (Object)configuration);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        String moduleKey = configuration.getModuleKey();
        ConfigurationData configurationData = configuration.getData();
        return this.getThenActionResponse(user, configurationData, validationResult, moduleKey);
    }

    public ThenActionResponse buildThenActionInput(@Nonnull ApplicationUser user, @Nonnull ComponentConfigurationInputImpl configuration, @Nonnull ValidationResult validationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configuration", (Object)configuration);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        ConfigurationData configurationData = configuration.getData();
        Option<String> moduleKeyOption = configuration.getModuleKey();
        if (moduleKeyOption.isEmpty()) {
            return this.getNoModuleKeyResponse(user, validationResult, configurationData);
        }
        String moduleKey = (String)moduleKeyOption.get();
        return this.getThenActionResponse(user, configurationData, validationResult, moduleKey);
    }

    private ThenActionResponse getThenActionResponse(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData, @Nonnull ValidationResult validationResult, @Nonnull String moduleKey) {
        Either<? extends ModuleAccessError, ThenActionData> thenActionDataResult = this.thenActionManager.getConfiguredThenActionData(user, moduleKey, configurationData);
        if (thenActionDataResult.isLeft()) {
            ModuleAccessError moduleAccessError = (ModuleAccessError)thenActionDataResult.left().get();
            if (moduleAccessError instanceof ModuleNotFoundError) {
                return this.getModuleNotFoundResponse(user, moduleKey, validationResult, configurationData);
            }
            return this.getModuleInvalidError(user, moduleKey, validationResult, configurationData);
        }
        ThenActionData thenActionData = (ThenActionData)thenActionDataResult.right().get();
        ThenActionDisplayData thenActionDisplayData = thenActionData.getThenActionDisplayData();
        ThenActionModuleData thenActionModuleData = thenActionData.getThenActionModuleData();
        return this.from(user, thenActionModuleData, thenActionDisplayData, validationResult, configurationData);
    }

    private ThenActionResponse getNoModuleKeyResponse(ApplicationUser user, ValidationResult validationResult, ConfigurationData configurationData) {
        return this.getModuleNotFoundResponse(user, "", validationResult, configurationData);
    }

    private ThenActionResponse getModuleNotFoundResponse(ApplicationUser user, String moduleKey, ValidationResult validationResult, ConfigurationData configurationData) {
        String unknownModuleName = this.i18nFactory.getInstance(user).getText("sd.automation.module.access.error.module.unknown", moduleKey);
        ThenActionModuleData thenActionModuleData = new ThenActionModuleData(moduleKey, unknownModuleName, (Option<String>)Option.some((Object)HELP_ICON_CLASS), (Option<String>)Option.none(), Sets.newHashSet());
        ThenActionDisplayData thenActionDisplayData = new ThenActionDisplayData(unknownModuleName, (Option<String>)Option.none());
        return this.from(user, thenActionModuleData, thenActionDisplayData, validationResult, configurationData);
    }

    private ThenActionResponse getModuleInvalidError(ApplicationUser user, String moduleKey, ValidationResult validationResult, ConfigurationData configurationData) {
        String invalidModuleName = this.i18nFactory.getInstance(user).getText("sd.automation.module.access.error.module.invalid", moduleKey);
        ThenActionModuleData thenActionModuleData = new ThenActionModuleData(moduleKey, invalidModuleName, (Option<String>)Option.some((Object)WARNING_ICON_CLASS), (Option<String>)Option.none(), Sets.newHashSet());
        ThenActionDisplayData thenActionDisplayData = new ThenActionDisplayData(invalidModuleName, (Option<String>)Option.none());
        return this.from(user, thenActionModuleData, thenActionDisplayData, validationResult, configurationData);
    }

    private ThenActionResponse from(ApplicationUser user, ThenActionModuleData thenActionModuleData, ThenActionDisplayData thenActionDisplayData, ValidationResult validationResult, ConfigurationData configurationData) {
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, validationResult);
        return new ThenActionResponse(thenActionModuleData.getModuleKey(), thenActionDisplayData.getName(), (String)thenActionDisplayData.getLabel().getOrNull(), (String)thenActionModuleData.getIconClass().getOrElse((Object)HELP_ICON_CLASS), (String)thenActionModuleData.getWebFormModule().getOrNull(), configurationData.getAll(), validationResponse, thenActionModuleData.getRequires());
    }

    private ThenActionModuleDataResponse from(ThenActionModuleData thenActionModuleData) {
        return new ThenActionModuleDataResponse(thenActionModuleData.getModuleKey(), thenActionModuleData.getName(), (String)thenActionModuleData.getIconClass().getOrNull(), (String)thenActionModuleData.getWebFormModule().getOrNull(), thenActionModuleData.getRequires());
    }

    public ThenActionModuleDataListResponse buildAllThenActionModuleList() {
        List<ThenActionModuleData> thenActionModuleDataList = this.thenActionManager.getThenActionModuleDataList();
        ArrayList responses = Lists.newArrayList();
        for (ThenActionModuleData data : thenActionModuleDataList) {
            responses.add(this.from(data));
        }
        return new ThenActionModuleDataListResponse(responses);
    }
}

