/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.When;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.blueprint.BlueprintDetails;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleSetValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleSetInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.LinkResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.blueprint.BlueprintDetailsResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.blueprint.BlueprintHelpResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.MetadataResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.RuleResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.WhenResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.MetadataResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.RuleResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.RuleSetResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.RuleSetSummaryResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationSummaryResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.WhenSummaryResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleSetResponseBuilder {
    private final RuleResponseBuilder ruleResponseBuilder;
    private final WhenResponseBuilder whenResponseBuilder;
    private final ValidationResponseBuilder validationResponseBuilder;
    private final MetadataResponseBuilder metadataResponseBuilder;

    @Autowired
    public RuleSetResponseBuilder(RuleResponseBuilder ruleResponseBuilder, WhenResponseBuilder whenResponseBuilder, @Nonnull ValidationResponseBuilder validationResponseBuilder, MetadataResponseBuilder metadataResponseBuilder) {
        this.whenResponseBuilder = whenResponseBuilder;
        this.metadataResponseBuilder = metadataResponseBuilder;
        this.validationResponseBuilder = validationResponseBuilder;
        this.ruleResponseBuilder = ruleResponseBuilder;
    }

    public RuleSetSummaryResponse buildSummary(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet, @Nonnull RuleSetValidationResult ruleSetValidationResult) {
        Assertions.notNull((String)"ruleSet", (Object)ruleSet);
        Assertions.notNull((String)"ruleSetValidationResult", (Object)ruleSetValidationResult);
        LinkResponse link = this.buildLinkResponse(ruleSet);
        WhenSummaryResponse whenSummaryResponse = null;
        boolean enabled = true;
        if (ruleSet.getRules().size() > 0) {
            Rule firstRule = (Rule)ruleSet.getRules().iterator().next();
            When when = firstRule.getWhen();
            whenSummaryResponse = this.whenResponseBuilder.buildSummary(user, when);
            enabled = firstRule.isEnabled();
        }
        ValidationSummaryResponse validationSummaryResponse = this.validationResponseBuilder.buildSummaryForRuleSet(user, ruleSet, ruleSetValidationResult);
        MetadataResponse metadataResponse = this.metadataResponseBuilder.build(user, ruleSet);
        return new RuleSetSummaryResponse(ruleSet.getId(), ruleSet.getName(), (String)ruleSet.getDescription().getOrNull(), link, whenSummaryResponse, metadataResponse, validationSummaryResponse, enabled);
    }

    public RuleSetResponse build(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet, RuleSetValidationResult ruleSetValidationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ruleSet", (Object)ruleSet);
        Assertions.notNull((String)"ruleSetValidationResult", (Object)ruleSetValidationResult);
        List<RuleResponse> ruleResponses = this.ruleResponseBuilder.build(user, ruleSet.getRules(), ruleSetValidationResult.getRuleValidationResults());
        LinkResponse linkResponse = this.buildLinkResponse(ruleSet);
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, ruleSetValidationResult.getRuleSetValidationResult());
        MetadataResponse metadataResponse = this.metadataResponseBuilder.build(user, ruleSet);
        return new RuleSetResponse(ruleSet.getId(), ruleSet.getName(), (String)ruleSet.getDescription().getOrElse((Object)""), linkResponse, ruleResponses, metadataResponse, validationResponse, this.activeRevisionIdFor(ruleSet));
    }

    private long activeRevisionIdFor(RuleSet ruleSet) {
        return ruleSet.getRevisionId();
    }

    public RuleSetResponse build(@Nonnull ApplicationUser user, @Nonnull RuleSetInput ruleSet, @Nonnull RuleSetValidationResult ruleSetValidationResult) {
        return this.buildWithExtraGlobalErrors(user, ruleSet, ruleSetValidationResult, new String[0]);
    }

    public BlueprintDetailsResponse buildBlueprintDetails(@Nonnull ApplicationUser user, @Nonnull BlueprintDetails blueprintDetails, @Nonnull RuleSetValidationResult ruleSetValidationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"blueprintDetails", (Object)blueprintDetails);
        Assertions.notNull((String)"ruleSetValidationResult", (Object)ruleSetValidationResult);
        RuleSetResponse ruleSetResponse = this.buildWithExtraGlobalErrors(user, blueprintDetails.getRuleSetInput(), ruleSetValidationResult, new String[0]);
        BlueprintHelpResponse blueprintHelpResponse = new BlueprintHelpResponse(blueprintDetails.getBlueprintHelp().getTitle(), blueprintDetails.getBlueprintHelp().getDescription(), (String)blueprintDetails.getBlueprintHelp().getTemplate().getOrNull());
        return new BlueprintDetailsResponse(ruleSetResponse.getName(), ruleSetResponse.getDescription(), ruleSetResponse.getRules(), ruleSetResponse.getMetadataResponse(), ruleSetResponse.getValidationResponse(), blueprintHelpResponse);
    }

    public RuleSetResponse buildWithExtraGlobalErrors(@Nonnull ApplicationUser user, @Nonnull RuleSetInput ruleSet, @Nonnull RuleSetValidationResult ruleSetValidationResult, String ... extraGlobalErrors) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ruleSet", (Object)ruleSet);
        Assertions.notNull((String)"ruleSetValidationResult", (Object)ruleSetValidationResult);
        RuleSetInputImpl impl = (RuleSetInputImpl)ruleSet;
        List<RuleResponse> ruleResponses = this.ruleResponseBuilder.buildFromInput(user, impl.getRuleInputs(), ruleSetValidationResult.getRuleValidationResults());
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, ruleSetValidationResult.getRuleSetValidationResult());
        if (extraGlobalErrors.length > 0) {
            ArrayList globalErrorsWithAdditions = Lists.newArrayList(validationResponse.getGlobalErrors());
            globalErrorsWithAdditions.addAll(Lists.newArrayList((Object[])extraGlobalErrors));
            validationResponse = new ValidationResponse(globalErrorsWithAdditions, validationResponse.getFieldErrors());
        }
        MetadataResponse metadataResponse = this.metadataResponseBuilder.buildFromInput(user, ruleSet);
        return new RuleSetResponse((Long)impl.getId().getOrNull(), (String)impl.getName().getOrNull(), (String)impl.getDescription().getOrNull(), null, ruleResponses, metadataResponse, validationResponse, null);
    }

    private LinkResponse buildLinkResponse(@Nonnull RuleSet ruleSet) {
        String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        return new LinkResponse(baseUrl + "/rest/servicedesk/automation/1/ruleset/" + ruleSet.getId(), "self");
    }
}

