/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.IfThenResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.WhenResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.IfThenResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.RuleResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.WhenResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleResponseBuilder {
    private final WhenResponseBuilder whenResponseBuilder;
    private final IfThenResponseBuilder ifThenResponseBuilder;
    private final ValidationResponseBuilder validationResponseBuilder;

    @Autowired
    public RuleResponseBuilder(@Nonnull WhenResponseBuilder whenResponseBuilder, @Nonnull IfThenResponseBuilder ifThenResponseBuilder, @Nonnull ValidationResponseBuilder validationResponseBuilder) {
        Assertions.notNull((String)"whenResponseBuilder", (Object)whenResponseBuilder);
        Assertions.notNull((String)"ifThenResponseBuilder", (Object)ifThenResponseBuilder);
        Assertions.notNull((String)"validationResponseBuilder", (Object)validationResponseBuilder);
        this.validationResponseBuilder = validationResponseBuilder;
        this.whenResponseBuilder = whenResponseBuilder;
        this.ifThenResponseBuilder = ifThenResponseBuilder;
    }

    public List<RuleResponse> build(@Nonnull ApplicationUser user, @Nonnull List<Rule> rules, @Nonnull List<RuleValidationResult> ruleValidationResults) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"rules", rules);
        Assertions.notNull((String)"ifThenValidationResults", ruleValidationResults);
        Assertions.isTrue((String)"ifThenValidationResults same size as rules", (ruleValidationResults.size() == rules.size() ? 1 : 0) != 0);
        ArrayList ruleResponses = Lists.newArrayList();
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = rules.get(i);
            RuleValidationResult ruleValidationResult = ruleValidationResults.get(i);
            ruleResponses.add(this.build(user, rule, ruleValidationResult));
        }
        return ruleResponses;
    }

    public RuleResponse build(@Nonnull ApplicationUser user, @Nonnull Rule rule, @Nonnull RuleValidationResult ruleValidationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"rule", (Object)rule);
        Assertions.notNull((String)"ruleValidationResult", (Object)ruleValidationResult);
        ruleValidationResult.getIfThenValidationResults();
        List<IfThenResponse> ifThenResponses = this.ifThenResponseBuilder.build(user, rule.getIfThens(), ruleValidationResult.getIfThenValidationResults());
        WhenResponse whenResponse = this.whenResponseBuilder.build(user, rule.getWhen(), ruleValidationResult.getWhenValidationResults());
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, ruleValidationResult.getRuleValidationResult());
        return new RuleResponse(whenResponse, ifThenResponses, validationResponse, rule.isEnabled());
    }

    public List<RuleResponse> buildFromInput(@Nonnull ApplicationUser user, @Nonnull List<RuleInputImpl> rules, @Nonnull List<RuleValidationResult> ruleValidationResults) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"rules", rules);
        Assertions.notNull((String)"ifThenValidationResults", ruleValidationResults);
        ArrayList ruleResponses = Lists.newArrayList();
        for (int i = 0; i < rules.size(); ++i) {
            RuleInputImpl rule = rules.get(i);
            RuleValidationResult ruleValidationResult = ruleValidationResults.get(i);
            ruleResponses.add(this.buildFromInput(user, rule, ruleValidationResult));
        }
        return ruleResponses;
    }

    public RuleResponse buildFromInput(@Nonnull ApplicationUser user, @Nonnull RuleInputImpl rule, @Nonnull RuleValidationResult ruleValidationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"rule", (Object)rule);
        Assertions.notNull((String)"ruleValidationResult", (Object)ruleValidationResult);
        ruleValidationResult.getIfThenValidationResults();
        List<IfThenResponse> ifThenResponses = this.ifThenResponseBuilder.buildFromInput(user, rule.getIfThenInputs(), ruleValidationResult.getIfThenValidationResults());
        WhenResponse whenResponse = this.whenResponseBuilder.buildFromInput(user, rule.getWhenInputs(), ruleValidationResult.getWhenValidationResults());
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, ruleValidationResult.getRuleValidationResult());
        return new RuleResponse(whenResponse, ifThenResponses, validationResponse, rule.isEnabled());
    }
}

