/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RuleSetRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleSetInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.user.input.RunAsUserContextInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.RunAsUserContextConfigResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.UserContextConfigResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ProjectContextResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.RunAsUserContextConfigResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.MetadataResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ProjectContextResponse;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetadataResponseBuilder {
    private final ProjectContextResponseBuilder projectContextResponseBuilder;
    private final RunAsUserContextConfigResponseBuilder runAsUserContextConfigResponseBuilder;
    private final RuleSetRunAsUserContextConfigService ruleSetRunAsUserContextConfigService;
    private final ProjectRunAsUserContextConfigService projectRunAsUserContextConfigService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ProjectManager projectManager;

    @Autowired
    public MetadataResponseBuilder(@Nonnull RunAsUserContextConfigResponseBuilder runAsUserContextConfigResponseBuilder, @Nonnull ProjectContextResponseBuilder projectContextResponseBuilder, RuleSetRunAsUserContextConfigService ruleSetRunAsUserContextConfigService, ProjectRunAsUserContextConfigService projectRunAsUserContextConfigService, I18nHelper.BeanFactory i18nFactory, ProjectManager projectManager) {
        this.runAsUserContextConfigResponseBuilder = runAsUserContextConfigResponseBuilder;
        this.projectContextResponseBuilder = projectContextResponseBuilder;
        this.ruleSetRunAsUserContextConfigService = ruleSetRunAsUserContextConfigService;
        this.projectRunAsUserContextConfigService = projectRunAsUserContextConfigService;
        this.i18nFactory = i18nFactory;
        this.projectManager = projectManager;
    }

    public MetadataResponse build(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet) {
        io.atlassian.fugue.Either contextForRuleSetEither = StepsConverters.newerEither((Either)this.ruleSetRunAsUserContextConfigService.getRunAsUserContextConfigForRuleSet(ruleSet)).map(StepsConverters::newerOption);
        RunAsUserContextConfigResponse runAsUserContextConfigResponse = null;
        if (contextForRuleSetEither.isRight()) {
            runAsUserContextConfigResponse = (RunAsUserContextConfigResponse)this.runAsUserContextConfigResponseBuilder.build((Option<RunAsUserContextConfig>)((Option)contextForRuleSetEither.right().get())).getOrNull();
        }
        ProjectContextResponse projectContextResponse = this.projectContextResponseBuilder.build(user, ruleSet);
        UserContextConfigResponse projectRunAsUser = this.getProjectRunAsUser(user, projectContextResponse);
        return new MetadataResponse(runAsUserContextConfigResponse, projectContextResponse, ruleSet.getTriggerFromOtherRules(), projectRunAsUser);
    }

    public MetadataResponse buildFromInput(@Nonnull ApplicationUser user, @Nonnull RuleSetInput ruleSetInput) {
        RunAsUserContextInputImpl ruleMetadataUserContextInput = ((RuleSetInputImpl)ruleSetInput).getRuleMetadata().getRuleMetadataUserContextInput();
        Option<RunAsUserContextConfig> runAsUserContextOpt = ruleMetadataUserContextInput.getUserContext();
        RunAsUserContextConfigResponse runAsUserContextConfigResponse = (RunAsUserContextConfigResponse)this.runAsUserContextConfigResponseBuilder.build(runAsUserContextOpt).getOrNull();
        ProjectContextResponse projectContextResponse = this.projectContextResponseBuilder.buildFromInput(user, ruleSetInput);
        UserContextConfigResponse projectRunAsUser = this.getProjectRunAsUser(user, projectContextResponse);
        return new MetadataResponse(runAsUserContextConfigResponse, projectContextResponse, (Boolean)((RuleSetInputImpl)ruleSetInput).getRuleMetadata().getTriggerFromOtherRules().getOrElse((Object)true), projectRunAsUser);
    }

    private UserContextConfigResponse getProjectRunAsUser(ApplicationUser user, ProjectContextResponse projectContextResponse) {
        Project project = this.projectManager.getProjectObj(projectContextResponse.getProjectId());
        if (project == null) {
            return this.getResponseForInvalidUser(user);
        }
        return this.getProjectRunAsUser(user, project);
    }

    private UserContextConfigResponse getProjectRunAsUser(ApplicationUser user, Project project) {
        io.atlassian.fugue.Either result = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.getContextConfigForProject(user, project)).map(StepsConverters::newerOption);
        if (result.isLeft()) {
            return this.getResponseForInvalidUser(user);
        }
        Option runAsUserOpt = (Option)result.right().get();
        Option<RunAsUserContextConfigResponse> responseOpt = this.runAsUserContextConfigResponseBuilder.build((Option<RunAsUserContextConfig>)runAsUserOpt);
        if (responseOpt.isEmpty()) {
            return this.getResponseForInvalidUser(user);
        }
        RunAsUserContextConfigResponse runAsUserContextConfigResponse = (RunAsUserContextConfigResponse)responseOpt.get();
        if ("specificUser".equals(runAsUserContextConfigResponse.getType())) {
            return runAsUserContextConfigResponse.getUser();
        }
        return this.getResponseForInvalidUser(user);
    }

    private UserContextConfigResponse getResponseForInvalidUser(ApplicationUser user) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        return UserContextConfigResponse.builder().userKey("").userDisplayName(i18n.getText("sd.automation.run.as.user.invalid")).isValid(false).build();
    }
}

