/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.ozymandias.error.ModuleNotFoundError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionData;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionModuleData;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.ValidationResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.IfConditionResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.ValidationResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.IfConditionModuleDataListResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.moduledata.IfConditionModuleDataResponse;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IfConditionResponseBuilder {
    private static final String HELP_ICON_CLASS = "help";
    private static final String WARNING_ICON_CLASS = "warning";
    private final ValidationResponseBuilder validationResponseBuilder;
    private final IfConditionManager ifConditionManager;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public IfConditionResponseBuilder(@Nonnull ValidationResponseBuilder validationResponseBuilder, @Nonnull IfConditionManager ifConditionManager, @Nonnull I18nHelper.BeanFactory i18nFactory) {
        this.validationResponseBuilder = validationResponseBuilder;
        this.ifConditionManager = ifConditionManager;
        this.i18nFactory = i18nFactory;
    }

    public IfConditionResponse buildIfCondition(@Nonnull ApplicationUser user, @Nonnull IfConditionConfiguration configuration, @Nonnull ValidationResult validationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configuration", (Object)configuration);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        String moduleKey = configuration.getModuleKey();
        ConfigurationData configurationData = configuration.getData();
        return this.getIfConditionResponse(user, validationResult, moduleKey, configurationData);
    }

    public IfConditionResponse buildIfConditionInput(@Nonnull ApplicationUser user, @Nonnull ComponentConfigurationInputImpl configuration, @Nonnull ValidationResult validationResult) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configuration", (Object)configuration);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        ConfigurationData configurationData = configuration.getData();
        Option<String> moduleKeyOption = configuration.getModuleKey();
        if (moduleKeyOption.isEmpty()) {
            return this.getNoModuleKeyResponse(user, validationResult, configurationData);
        }
        String moduleKey = (String)moduleKeyOption.get();
        return this.getIfConditionResponse(user, validationResult, moduleKey, configurationData);
    }

    public IfConditionModuleDataListResponse buildIfConditionModuleList() {
        List<IfConditionModuleData> ifConditionModuleDataList = this.ifConditionManager.getIfConditionModuleDataList();
        ArrayList responses = Lists.newArrayList();
        for (IfConditionModuleData data : ifConditionModuleDataList) {
            responses.add(this.from(data));
        }
        return new IfConditionModuleDataListResponse(responses);
    }

    private IfConditionResponse getIfConditionResponse(ApplicationUser user, ValidationResult validationResult, String moduleKey, ConfigurationData configurationData) {
        Either<? extends ModuleAccessError, IfConditionData> ifConditionDataResult = this.ifConditionManager.getConfiguredIfConditionData(user, moduleKey, configurationData);
        if (ifConditionDataResult.isLeft()) {
            ModuleAccessError moduleAccessError = (ModuleAccessError)ifConditionDataResult.left().get();
            if (moduleAccessError instanceof ModuleNotFoundError) {
                return this.getModuleNotFoundResponse(user, moduleKey, validationResult, configurationData);
            }
            return this.getModuleInvalidError(user, moduleKey, validationResult, configurationData);
        }
        IfConditionData ifConditionData = (IfConditionData)ifConditionDataResult.right().get();
        IfConditionDisplayData ifConditionDisplayData = ifConditionData.getIfConditionDisplayData();
        IfConditionModuleData ifConditionModuleData = ifConditionData.getIfConditionModuleData();
        return this.from(user, ifConditionModuleData, ifConditionDisplayData, validationResult, configurationData);
    }

    private IfConditionResponse getNoModuleKeyResponse(ApplicationUser user, ValidationResult validationResult, ConfigurationData configurationData) {
        return this.getModuleNotFoundResponse(user, "", validationResult, configurationData);
    }

    private IfConditionResponse getModuleNotFoundResponse(ApplicationUser user, String moduleKey, ValidationResult validationResult, ConfigurationData configurationData) {
        String unknownModuleName = this.i18nFactory.getInstance(user).getText("sd.automation.module.access.error.module.unknown", moduleKey);
        IfConditionModuleData ifConditionModuleData = new IfConditionModuleData(moduleKey, unknownModuleName, (Option<String>)Option.some((Object)HELP_ICON_CLASS), (Option<String>)Option.none(), Sets.newHashSet());
        IfConditionDisplayData ifConditionDisplayData = new IfConditionDisplayData(unknownModuleName, (Option<String>)Option.none());
        return this.from(user, ifConditionModuleData, ifConditionDisplayData, validationResult, configurationData);
    }

    private IfConditionResponse getModuleInvalidError(ApplicationUser user, String moduleKey, ValidationResult validationResult, ConfigurationData configurationData) {
        String invalidModuleName = this.i18nFactory.getInstance(user).getText("sd.automation.module.access.error.module.invalid", moduleKey);
        IfConditionModuleData ifConditionModuleData = new IfConditionModuleData(moduleKey, invalidModuleName, (Option<String>)Option.some((Object)WARNING_ICON_CLASS), (Option<String>)Option.none(), Sets.newHashSet());
        IfConditionDisplayData ifConditionDisplayData = new IfConditionDisplayData(invalidModuleName, (Option<String>)Option.none());
        return this.from(user, ifConditionModuleData, ifConditionDisplayData, validationResult, configurationData);
    }

    private IfConditionResponse from(ApplicationUser user, IfConditionModuleData ifConditionModuleData, IfConditionDisplayData ifConditionDisplayData, ValidationResult validationResult, ConfigurationData configurationData) {
        ValidationResponse validationResponse = this.validationResponseBuilder.build(user, validationResult);
        return new IfConditionResponse(ifConditionModuleData.getModuleKey(), ifConditionDisplayData.getName(), (String)ifConditionDisplayData.getLabel().getOrNull(), (String)ifConditionModuleData.getIconClass().getOrElse((Object)HELP_ICON_CLASS), (String)ifConditionModuleData.getWebFormModule().getOrNull(), configurationData.getAll(), validationResponse, ifConditionModuleData.getRequires());
    }

    private IfConditionModuleDataResponse from(IfConditionModuleData ifConditionModuleData) {
        return new IfConditionModuleDataResponse(ifConditionModuleData.getModuleKey(), ifConditionModuleData.getName(), (String)ifConditionModuleData.getIconClass().getOrNull(), (String)ifConditionModuleData.getWebFormModule().getOrNull(), ifConditionModuleData.getRequires());
    }
}

