/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest.response.auditlog;

import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogComponentDetailData;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class LogDetailData {
    private final boolean error;
    private final String status;
    private final String displayData;
    private final String outcomeMessage;

    public LogDetailData(RuleSetAuditLogComponentDetailData detailData) {
        this.error = detailData.isError();
        this.status = detailData.getStatus().name();
        this.displayData = detailData.getDisplayData();
        this.outcomeMessage = (String)detailData.getOutcomeMessage().getOrNull();
    }

    public boolean isError() {
        return this.error;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDisplayData() {
        return this.displayData;
    }

    public String getOutcomeMessage() {
        return this.outcomeMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogDetailData that = (LogDetailData)o;
        return this.error == that.error && Objects.equals(this.status, that.status) && Objects.equals(this.displayData, that.displayData) && Objects.equals(this.outcomeMessage, that.outcomeMessage);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.status, this.displayData, this.outcomeMessage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("error", this.error).add("status", (Object)this.status).add("displayData", (Object)this.displayData).add("outcomeMessage", (Object)this.outcomeMessage).toString();
    }
}

