/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorCollectionHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSetService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.blueprint.BlueprintDetails;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputValidationService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleSetValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleSetValidationService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationOutcome;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.analytics.AnalyticsService;
import com.atlassian.servicedesk.plugins.automation.internal.analytics.ConcurrentEditingFailureEvent;
import com.atlassian.servicedesk.plugins.automation.internal.module.BlueprintManager;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.servicedesk.plugins.automation.internal.rest.AbstractAutomationPluginResource;
import com.atlassian.servicedesk.plugins.automation.internal.rest.helper.RuleSetInputTransformer;
import com.atlassian.servicedesk.plugins.automation.internal.rest.request.CreateRuleSetRequest;
import com.atlassian.servicedesk.plugins.automation.internal.rest.request.UpdateRuleSetRequest;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.RuleSetResponseBuilder;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ruleset")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RuleSetResource
extends AbstractAutomationPluginResource {
    private static final Logger log = LoggerFactory.getLogger(RuleSetResource.class);
    private final ProjectService projectService;
    private final RuleSetService ruleSetService;
    private final RuleSetInputValidationService ruleSetInputValidationService;
    private final RuleSetValidationService ruleSetValidationService;
    private final RuleSetResponseBuilder ruleSetResponseBuilder;
    private final BlueprintManager blueprintManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final AnalyticsService analyticsService;
    private final RuleSetInputTransformer ruleSetInputTransformer;

    public RuleSetResource(@Nonnull JiraAuthenticationContext authenticationContext, @Nonnull ProjectService projectService, @Nonnull RuleSetService ruleSetService, @Nonnull RuleSetResponseBuilder ruleSetResponseBuilder, @Nonnull BlueprintManager blueprintManager, @Nonnull I18nHelper.BeanFactory i18nFactory, @Nonnull RuleSetInputValidationService ruleSetInputValidationService, @Nonnull RuleSetValidationService ruleSetValidationService, @Nonnull AutomationPermissionManager automationPermissionManager, @Nonnull AnalyticsService analyticsService, @Nonnull RuleSetInputTransformer ruleSetInputTransformer) {
        super(authenticationContext, automationPermissionManager);
        this.projectService = projectService;
        this.ruleSetService = ruleSetService;
        this.ruleSetInputValidationService = ruleSetInputValidationService;
        this.ruleSetValidationService = ruleSetValidationService;
        this.ruleSetResponseBuilder = ruleSetResponseBuilder;
        this.blueprintManager = blueprintManager;
        this.i18nFactory = i18nFactory;
        this.analyticsService = analyticsService;
        this.ruleSetInputTransformer = ruleSetInputTransformer;
    }

    @GET
    @Path(value="/{ruleSetId}")
    public Response getRuleSet(@PathParam(value="ruleSetId") long ruleSetId) {
        log.debug("Getting ruleset with id '{}'", (Object)ruleSetId);
        io.atlassian.fugue.Either ruleSetResult = StepsConverters.newerEither((Either)this.ruleSetService.getById(this.getUser(), ruleSetId));
        if (ruleSetResult.isLeft()) {
            log.debug("Unable to get ruleset with id '{}'; no ruleset with that id exists", (Object)ruleSetId);
            return this.errorResponse("sd.automation.get.rule.set.failed", (AnError)ruleSetResult.left().get());
        }
        RuleSet ruleSet = (RuleSet)ruleSetResult.right().get();
        if (ruleSet.isSystemRuleSet()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        RuleSetValidationResult validateResult = this.ruleSetValidationService.validate(this.getUser(), ruleSet);
        log.debug("Returning the following ruleset: {}; with the following validation result: {}", (Object)ruleSet, (Object)validateResult);
        return Response.ok((Object)this.ruleSetResponseBuilder.build(this.getUser(), ruleSet, validateResult)).build();
    }

    @POST
    @Path(value="/{ruleSetId}/validate")
    public Response validateRuleSetForUpdate(@PathParam(value="ruleSetId") long ruleSetId, UpdateRuleSetRequest request) {
        return this.validateRuleSetForUpdate(ruleSetId, request, (io.atlassian.fugue.Option<Long>)io.atlassian.fugue.Option.none(Long.class));
    }

    @POST
    @Path(value="/{ruleSetId}/expectedRevisionId/{expectedRevisionId}/validate")
    public Response validateRuleSetForUpdateWithVersionCheck(@PathParam(value="ruleSetId") long ruleSetId, @PathParam(value="expectedRevisionId") long expectedRevisionId, UpdateRuleSetRequest request) {
        return this.validateRuleSetForUpdate(ruleSetId, request, (io.atlassian.fugue.Option<Long>)io.atlassian.fugue.Option.some((Object)expectedRevisionId));
    }

    private Response validateRuleSetForUpdate(long ruleSetId, UpdateRuleSetRequest request, io.atlassian.fugue.Option<Long> expectedRevisionId) {
        io.atlassian.fugue.Either existingRuleSetEither = StepsConverters.newerEither((Either)this.ruleSetService.getById(this.getUser(), ruleSetId));
        if (existingRuleSetEither.isLeft()) {
            return this.errorResponse("sd.automation.get.rule.set.failed", (AnError)existingRuleSetEither.left().get());
        }
        RuleSet existingRuleSet = (RuleSet)existingRuleSetEither.right().get();
        if (existingRuleSet.isSystemRuleSet()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        io.atlassian.fugue.Either<AnError, RuleSetInput> ruleSetInputEither = this.ruleSetInputTransformer.requestToRuleSetInput(request, ruleSetId);
        if (ruleSetInputEither.isLeft()) {
            return this.errorResponse("sd.automation.rule.set.request.invalid", (AnError)ruleSetInputEither.left().get());
        }
        RuleSetInput ruleSetInput = (RuleSetInput)ruleSetInputEither.right().get();
        io.atlassian.fugue.Either anErrorValidationOutcomeEither = StepsConverters.newerEither((Either)this.ruleSetInputValidationService.validate(this.getUser(), ruleSetInput));
        if (anErrorValidationOutcomeEither.isLeft()) {
            AnError errorResult = (AnError)anErrorValidationOutcomeEither.left().get();
            return this.errorResponse("sd.automation.validate.rule.set.failed", errorResult);
        }
        io.atlassian.fugue.Option<String> activeRevisionChangedError = this.checkIfActiveRevisionChanged(expectedRevisionId, existingRuleSet);
        ValidationOutcome outcome = (ValidationOutcome)anErrorValidationOutcomeEither.right().get();
        if (outcome.getRuleSetValidationResult().isPassed() && activeRevisionChangedError.isEmpty()) {
            return Response.ok((Object)this.ruleSetResponseBuilder.build(this.getUser(), ruleSetInput, outcome.getRuleSetValidationResult())).build();
        }
        if (activeRevisionChangedError.isDefined()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.ruleSetResponseBuilder.buildWithExtraGlobalErrors(this.getUser(), ruleSetInput, outcome.getRuleSetValidationResult(), (String)activeRevisionChangedError.get())).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.ruleSetResponseBuilder.build(this.getUser(), ruleSetInput, outcome.getRuleSetValidationResult())).build();
    }

    private io.atlassian.fugue.Option<String> checkIfActiveRevisionChanged(io.atlassian.fugue.Option<Long> expectedRevisionId, RuleSet existingRuleSet) {
        return expectedRevisionId.flatMap(revisionId -> StepsConverters.newerOption((Option)this.ruleSetService.checkActiveRevisionForRuleSet(this.getUser(), existingRuleSet, revisionId.longValue()).map(this::getActiveRevisionChangedErrorMessage)));
    }

    private String getActiveRevisionChangedErrorMessage(AnError activeRevisionHasChangedError) {
        return (String)activeRevisionHasChangedError.getMessage().getI18n().fold(() -> activeRevisionHasChangedError.getMessage().getMessage(), i18n -> {
            this.analyticsService.fireAnalyticsEvent(new ConcurrentEditingFailureEvent());
            return this.i18nFactory.getInstance(this.getUser()).getText(i18n.getI18nKey(), (Object)i18n.getParams());
        });
    }

    @POST
    @Path(value="/validate")
    public Response validateRuleSetForCreate(CreateRuleSetRequest request) {
        io.atlassian.fugue.Either<AnError, RuleSetInput> ruleSetInputEither = this.ruleSetInputTransformer.requestToRuleSetInput(request);
        if (ruleSetInputEither.isLeft()) {
            return this.errorResponse("sd.automation.create.validation.failed", (AnError)ruleSetInputEither.left().get());
        }
        RuleSetInput ruleSetInput = (RuleSetInput)ruleSetInputEither.right().get();
        io.atlassian.fugue.Either anErrorValidationOutcomeEither = StepsConverters.newerEither((Either)this.ruleSetInputValidationService.validate(this.getUser(), ruleSetInput));
        if (anErrorValidationOutcomeEither.isLeft()) {
            AnError errorResult = (AnError)anErrorValidationOutcomeEither.left().get();
            return this.errorResponse("sd.automation.update.rule.set.failed", errorResult);
        }
        ValidationOutcome outcome = (ValidationOutcome)anErrorValidationOutcomeEither.right().get();
        if (!outcome.getRuleSetValidationResult().isPassed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.ruleSetResponseBuilder.build(this.getUser(), ruleSetInput, outcome.getRuleSetValidationResult())).build();
        }
        return Response.ok((Object)this.ruleSetResponseBuilder.build(this.getUser(), ruleSetInput, outcome.getRuleSetValidationResult())).build();
    }

    @POST
    @Path(value="/")
    public Response createRuleSet(CreateRuleSetRequest request) {
        log.debug("Creating a new ruleset");
        io.atlassian.fugue.Either<AnError, RuleSetInput> ruleSetInputEither = this.ruleSetInputTransformer.requestToRuleSetInput(request);
        if (ruleSetInputEither.isLeft()) {
            return this.errorResponse("sd.automation.create.rule.set.failed", (AnError)ruleSetInputEither.left().get());
        }
        RuleSetInput ruleSetInput = (RuleSetInput)ruleSetInputEither.right().get();
        io.atlassian.fugue.Either anErrorValidationOutcomeEither = StepsConverters.newerEither((Either)this.ruleSetInputValidationService.validate(this.getUser(), ruleSetInput));
        if (anErrorValidationOutcomeEither.isLeft()) {
            AnError errorResult = (AnError)anErrorValidationOutcomeEither.left().get();
            log.debug("Unable to validate the request to create a new ruleset due to: {}", (Object)errorResult.getMessage().getMessage());
            return this.errorResponse("sd.automation.create.rule.set.failed", errorResult);
        }
        ValidationOutcome outcome = (ValidationOutcome)anErrorValidationOutcomeEither.right().get();
        if (!outcome.getRuleSetValidationResult().isPassed()) {
            log.debug("Unable to create a new ruleset. Validation failed with the following outcome: {}", (Object)outcome);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.ruleSetResponseBuilder.build(this.getUser(), ruleSetInput, outcome.getRuleSetValidationResult())).build();
        }
        io.atlassian.fugue.Either ruleSetCreateResult = StepsConverters.newerEither((Either)this.ruleSetService.create(this.getUser(), (ValidatedRuleSet)outcome.getValidatedRuleSet().get()));
        if (ruleSetCreateResult.isLeft()) {
            AnError errorResult = (AnError)ruleSetCreateResult.left().get();
            log.debug("Unable to create a new ruleset due to: {}", (Object)errorResult.getMessage().getMessage());
            return this.errorResponse("sd.automation.create.rule.set.failed", errorResult);
        }
        RuleSet newlyCreated = (RuleSet)ruleSetCreateResult.right().get();
        log.debug("Successfully created new ruleset. New ruleset has id: {}", (Object)newlyCreated.getId());
        return Response.ok((Object)this.ruleSetResponseBuilder.build(this.getUser(), newlyCreated, outcome.getRuleSetValidationResult())).build();
    }

    @PUT
    @Path(value="/{ruleSetId}")
    public Response updateRuleSet(@PathParam(value="ruleSetId") long ruleSetId, UpdateRuleSetRequest request) {
        return this.validateRequestAndUpdateRuleSet(ruleSetId, (io.atlassian.fugue.Option<Long>)io.atlassian.fugue.Option.none(Long.class), request);
    }

    @PUT
    @Path(value="/{ruleSetId}/expectedRevisionId/{expectedRevisionId}")
    public Response updateRuleSetWithVersionCheck(@PathParam(value="ruleSetId") long ruleSetId, @PathParam(value="expectedRevisionId") long expectedRevisionId, UpdateRuleSetRequest request) {
        return this.validateRequestAndUpdateRuleSet(ruleSetId, (io.atlassian.fugue.Option<Long>)io.atlassian.fugue.Option.some((Object)expectedRevisionId), request);
    }

    private Response validateRequestAndUpdateRuleSet(long ruleSetId, io.atlassian.fugue.Option<Long> expectedRevisionId, UpdateRuleSetRequest request) {
        io.atlassian.fugue.Option activeRevisionHasChangedError;
        boolean expectingRevisionId = expectedRevisionId.isDefined();
        log.debug("Updating existing ruleset with id: '{}' " + (expectingRevisionId ? ", with expected active revision id: ' + " + expectedRevisionId + "'" : ""), (Object)ruleSetId);
        io.atlassian.fugue.Either existingRuleSetEither = StepsConverters.newerEither((Either)this.ruleSetService.getById(this.getUser(), ruleSetId));
        if (existingRuleSetEither.isLeft()) {
            log.debug("Unable to update existing ruleset with id '{}'. No ruleset exists with that id.", (Object)ruleSetId);
            return this.errorResponse("sd.automation.update.rule.set.failed", (AnError)existingRuleSetEither.left().get());
        }
        RuleSet existingRuleSet = (RuleSet)existingRuleSetEither.right().get();
        if (existingRuleSet.isSystemRuleSet()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        io.atlassian.fugue.Either<AnError, RuleSetInput> ruleSetInputEither = this.ruleSetInputTransformer.requestToRuleSetInput(request, ruleSetId);
        if (ruleSetInputEither.isLeft()) {
            log.debug("Unable to update existing ruleset with id '{}'. The updated ruleset request was invalid. The request contained: {}", (Object)ruleSetId, (Object)request);
            return this.errorResponse("sd.automation.update.rule.set.failed", (AnError)ruleSetInputEither.left().get());
        }
        RuleSetInput ruleSetInput = (RuleSetInput)ruleSetInputEither.right().get();
        if (expectingRevisionId && (activeRevisionHasChangedError = StepsConverters.newerOption((Option)this.ruleSetService.checkActiveRevisionForRuleSet(this.getUser(), existingRuleSet, ((Long)expectedRevisionId.get()).longValue()))).isDefined()) {
            log.debug("Unable to update existing ruleset with id: {}. The expected active revision id ('{}') has changed.", expectedRevisionId.get());
            return this.errorResponse("sd.automation.rule.set.error.rule.set.update.active.revision.changed", (AnError)activeRevisionHasChangedError.get());
        }
        io.atlassian.fugue.Either anErrorValidationOutcomeEither = StepsConverters.newerEither((Either)this.ruleSetInputValidationService.validate(this.getUser(), ruleSetInput));
        if (anErrorValidationOutcomeEither.isLeft()) {
            AnError errorResult = (AnError)anErrorValidationOutcomeEither.left().get();
            log.debug("Unable to validate the request to update existing ruleset with id '{}' due to: {}", (Object)ruleSetId, (Object)errorResult.getMessage().getMessage());
            return this.errorResponse("sd.automation.validate.rule.set.failed", errorResult);
        }
        ValidationOutcome outcome = (ValidationOutcome)anErrorValidationOutcomeEither.right().get();
        if (!outcome.getRuleSetValidationResult().isPassed()) {
            log.debug("Unable to update existing ruleset with id '{}'. Validation failed with the following outcome: {}", (Object)ruleSetId, (Object)outcome);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.ruleSetResponseBuilder.build(this.getUser(), ruleSetInput, outcome.getRuleSetValidationResult())).build();
        }
        io.atlassian.fugue.Either updatedRuleSet = expectingRevisionId ? StepsConverters.newerEither((Either)this.ruleSetService.update(this.getUser(), existingRuleSet.getId(), (ValidatedRuleSet)outcome.getValidatedRuleSet().get(), StepsConverters.olderOption(expectedRevisionId))) : StepsConverters.newerEither((Either)this.ruleSetService.update(this.getUser(), existingRuleSet.getId(), (ValidatedRuleSet)outcome.getValidatedRuleSet().get(), StepsConverters.olderOption((io.atlassian.fugue.Option)io.atlassian.fugue.Option.none())));
        if (updatedRuleSet.isLeft()) {
            AnError errorResult = (AnError)updatedRuleSet.left().get();
            log.debug("Unable to update existing ruleset with id '{}' due to: {}", (Object)ruleSetId, (Object)errorResult.getMessage().getMessage());
            return this.errorResponse("sd.automation.update.rule.set.failed", errorResult);
        }
        log.debug("Successfully updated existing ruleset with id: {}", (Object)ruleSetId);
        return Response.ok((Object)this.ruleSetResponseBuilder.build(this.getUser(), (RuleSet)updatedRuleSet.right().get(), outcome.getRuleSetValidationResult())).build();
    }

    @GET
    @Path(value="/blueprint/{blueprintModuleKey}/project/{projectKey}")
    public Response getBlueprintDetails(@PathParam(value="blueprintModuleKey") String blueprintModuleKey, @PathParam(value="projectKey") String projectKey) {
        ProjectContext projectContext;
        io.atlassian.fugue.Either<AnError, Project> projectEither = this.getProject(projectKey);
        if (projectEither.isLeft()) {
            return this.errorResponse("sd.automation.get.project.failed", (AnError)projectEither.left().get());
        }
        Project project = (Project)projectEither.right().get();
        ApplicationUser user = this.getUser();
        io.atlassian.fugue.Either<AnError, BlueprintDetails> blueprintDetailsResult = this.blueprintManager.getBlueprintDetails(user, blueprintModuleKey, projectContext = this.buildProjectContext(project));
        if (blueprintDetailsResult.isLeft()) {
            AnError errorResult = (AnError)blueprintDetailsResult.left().get();
            return this.errorResponse("sd.automation.rule.set.request.invalid", errorResult);
        }
        BlueprintDetails blueprintDetails = (BlueprintDetails)blueprintDetailsResult.right().get();
        io.atlassian.fugue.Either outcomeEither = StepsConverters.newerEither((Either)this.ruleSetInputValidationService.validate(user, blueprintDetails.getRuleSetInput()));
        if (outcomeEither.isLeft()) {
            AnError errorResult = (AnError)outcomeEither.left().get();
            return this.errorResponse("sd.automation.validate.rule.set.failed", errorResult);
        }
        ValidationOutcome outcome = (ValidationOutcome)outcomeEither.right().get();
        return Response.ok((Object)this.ruleSetResponseBuilder.buildBlueprintDetails(user, blueprintDetails, outcome.getRuleSetValidationResult())).build();
    }

    @DELETE
    @Path(value="/{ruleSetId}")
    public Response deleteRuleSet(@PathParam(value="ruleSetId") long ruleSetId) {
        log.debug("Deleting existing ruleset with id: '{}'", (Object)ruleSetId);
        io.atlassian.fugue.Either existingRuleSetEither = StepsConverters.newerEither((Either)this.ruleSetService.getById(this.getUser(), ruleSetId));
        if (existingRuleSetEither.isLeft()) {
            log.debug("Unable to delete existing ruleset with id '{}'", (Object)ruleSetId);
            return this.errorResponse("sd.automation.get.rule.set.failed", (AnError)existingRuleSetEither.left().get());
        }
        RuleSet existingRuleSet = (RuleSet)existingRuleSetEither.right().get();
        if (existingRuleSet.isSystemRuleSet()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        io.atlassian.fugue.Either result = StepsConverters.newerEither((Either)this.ruleSetService.delete(this.getUser(), existingRuleSet));
        if (result.isLeft()) {
            log.debug("Unable to delete existing ruleset with id '{}'", (Object)ruleSetId);
            return this.errorResponse("sd.automation.delete.rule.set.failed", (AnError)result.left().get());
        }
        return Response.ok().build();
    }

    private io.atlassian.fugue.Either<AnError, Project> getProject(String projectKey) {
        ProjectService.GetProjectResult projectByKey = this.projectService.getProjectByKey(this.getUser(), projectKey);
        if (!projectByKey.isValid()) {
            return StepsConverters.newerEither((Either)ErrorCollectionHelper.error((ErrorCollection)projectByKey.getErrorCollection()));
        }
        return io.atlassian.fugue.Either.right((Object)projectByKey.getProject());
    }
}

