/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSetService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleSetValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleSetValidationService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.module.BlueprintManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.BlueprintModuleData;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.servicedesk.plugins.automation.internal.rest.AbstractAutomationPluginResource;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.AutomationSettingsPageResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.ProjectRunAsUserSettingsResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.blueprint.BlueprintResponse;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.RuleSetResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.builder.RunAsUserContextConfigResponseBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.rest.response.rule.RuleSetSummaryResponse;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/pages/settings/automation/{projectKey}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Scanned
public class AutomationSettingsPageResource
extends AbstractAutomationPluginResource {
    private final RuleSetService ruleSetService;
    private final RuleSetResponseBuilder ruleSetResponseBuilder;
    private final RuleSetValidationService ruleSetValidationService;
    private final ProjectRunAsUserContextConfigService projectRunAsUserContextConfigService;
    private final RunAsUserContextConfigResponseBuilder runAsUserContextConfigResponseBuilder;
    private final BlueprintManager blueprintManager;
    private final ProjectService projectService;

    public AutomationSettingsPageResource(@Nonnull JiraAuthenticationContext jiraAuthenticationContext, @Nonnull RuleSetService ruleSetService, @Nonnull RuleSetResponseBuilder ruleSetResponseBuilder, @Nonnull RuleSetValidationService ruleSetValidationService, @Nonnull ProjectRunAsUserContextConfigService projectRunAsUserContextConfigService, @Nonnull RunAsUserContextConfigResponseBuilder runAsUserContextConfigResponseBuilder, @Nonnull BlueprintManager blueprintManager, @Nonnull AutomationPermissionManager automationPermissionManager, @Nonnull ProjectService projectService) {
        super(jiraAuthenticationContext, automationPermissionManager);
        this.ruleSetService = ruleSetService;
        this.ruleSetResponseBuilder = ruleSetResponseBuilder;
        this.ruleSetValidationService = ruleSetValidationService;
        this.projectRunAsUserContextConfigService = projectRunAsUserContextConfigService;
        this.runAsUserContextConfigResponseBuilder = runAsUserContextConfigResponseBuilder;
        this.blueprintManager = blueprintManager;
        this.projectService = projectService;
    }

    @GET
    public Response getAutomationPage(@PathParam(value="projectKey") String projectKey) {
        final ApplicationUser user = this.getUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return this.errorResponse("sd.automation.error.project.not.found", projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        io.atlassian.fugue.Either ruleSetsResult = StepsConverters.newerEither((Either)this.ruleSetService.getActiveRuleSetsByProject(user, project));
        if (ruleSetsResult.isLeft()) {
            return this.errorResponse("ruleset.get.failed", (AnError)ruleSetsResult.left().get());
        }
        List ruleSets = ((List)ruleSetsResult.right().get()).stream().filter(ruleSet -> !ruleSet.isSystemRuleSet()).collect(Collectors.toList());
        List ruleSetValidationResults = Lists.transform(ruleSets, (Function)new Function<RuleSet, RuleSetValidationResult>(){

            @Nullable
            public RuleSetValidationResult apply(@Nullable RuleSet ruleSet) {
                return AutomationSettingsPageResource.this.ruleSetValidationService.validate(user, ruleSet);
            }
        });
        ArrayList ruleSetSummaryResponses = Lists.newArrayList();
        for (int i = 0; i < ruleSets.size(); ++i) {
            RuleSet ruleSet2 = (RuleSet)ruleSets.get(i);
            RuleSetValidationResult ruleSetValidationResult = (RuleSetValidationResult)ruleSetValidationResults.get(i);
            RuleSetSummaryResponse ruleSetSummaryResponse = this.ruleSetResponseBuilder.buildSummary(user, ruleSet2, ruleSetValidationResult);
            ruleSetSummaryResponses.add(ruleSetSummaryResponse);
        }
        io.atlassian.fugue.Either runAsProjectContextResult = StepsConverters.newerEither((Either)this.projectRunAsUserContextConfigService.getContextConfigForProject(user, project)).map(StepsConverters::newerOption);
        if (runAsProjectContextResult.isLeft()) {
            return this.errorResponse("sd.automation.run.as.user.setting.get.failed", (AnError)runAsProjectContextResult.left().get());
        }
        Option runAsUserContextConfig = (Option)runAsProjectContextResult.right().get();
        ProjectRunAsUserSettingsResponse projectRunAsUserSettingsResponse = this.runAsUserContextConfigResponseBuilder.buildProjectSettingsResponse(project, (Option<RunAsUserContextConfig>)runAsUserContextConfig, false);
        List<BlueprintModuleData> blueprintModuleDataList = this.blueprintManager.getBlueprintModuleDataList(user, this.buildProjectContext(project));
        ArrayList blueprintSummaryResponses = Lists.newArrayList();
        Collections.sort(blueprintModuleDataList, new Comparator<BlueprintModuleData>(){

            @Override
            public int compare(BlueprintModuleData first, BlueprintModuleData second) {
                return first.getWeight().compareTo(second.getWeight());
            }
        });
        for (BlueprintModuleData data : blueprintModuleDataList) {
            blueprintSummaryResponses.add(this.from(data));
        }
        return this.ok(new AutomationSettingsPageResponse(ruleSetSummaryResponses, projectRunAsUserSettingsResponse, blueprintSummaryResponses));
    }

    private BlueprintResponse from(BlueprintModuleData blueprintModuleData) {
        return new BlueprintResponse(blueprintModuleData.getModuleKey(), blueprintModuleData.getName(), (String)blueprintModuleData.getIconPath().getOrNull(), blueprintModuleData.getDescription(), blueprintModuleData.getWeight());
    }
}

