/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.rest;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.api.rest.AbstractRestResource;
import com.atlassian.pocketknife.api.rest.RestErrorResponse;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.project.ProjectContextImpl;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAutomationPluginResource
extends AbstractRestResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final AutomationPermissionManager automationPermissionManager;
    private static final Logger log = LoggerFactory.getLogger(AbstractAutomationPluginResource.class);

    protected AbstractAutomationPluginResource(@Nonnull JiraAuthenticationContext jiraAuthenticationContext, @Nonnull AutomationPermissionManager automationPermissionManager) {
        super(AbstractAutomationPluginResource.class, jiraAuthenticationContext);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.automationPermissionManager = automationPermissionManager;
    }

    protected ApplicationUser getUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    protected Response errorResponse(String reasonKey, AnError anError) {
        Response.Status status = Response.Status.fromStatusCode((int)anError.getHttpStatusCode());
        RestErrorResponse error = new RestErrorResponse(reasonKey, String.valueOf(status.getStatusCode()));
        error.addError(anError.getMessage().getMessage());
        log.debug("Constructing error response with status code: '{}', reason key: '{}' and error message: {}", new Object[]{status.getStatusCode(), reasonKey, anError.getMessage().getMessage()});
        return Response.status((Response.Status)status).entity((Object)error).build();
    }

    protected Either<AnError, Unit> hasAdminOrProjectAdminPermission() {
        ApplicationUser applicationUser = this.getUser();
        boolean canManageRuleSets = this.automationPermissionManager.canManageSomeRuleSet(applicationUser);
        return this.automationPermissionManager.toEither(applicationUser, canManageRuleSets);
    }

    protected Either<AnError, Unit> canManageRuleForProject(Project project) {
        ApplicationUser applicationUser = this.getUser();
        boolean canManageRuleSets = this.automationPermissionManager.hasManageRuleSetPermission(applicationUser, project);
        return this.automationPermissionManager.toEither(applicationUser, canManageRuleSets);
    }

    protected ProjectContext buildProjectContext(Project project) {
        return new ProjectContextImpl(project);
    }
}

