/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.permission;

import com.atlassian.fugue.Either;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.project.ProjectContextImpl;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutomationPermissionManagerImpl
implements AutomationPermissionManager {
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public AutomationPermissionManagerImpl(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, ErrorResultHelper errorResultHelper) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public boolean hasManageRuleSetPermission(@Nonnull ApplicationUser user, @Nonnull Project project) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"project", (Object)project);
        ProjectContextImpl projectContext = new ProjectContextImpl(project);
        return this.hasManageRuleSetPermission(user, (Option<ProjectContext>)Option.some((Object)projectContext));
    }

    @Override
    public boolean hasManageRuleSetPermission(@Nonnull ApplicationUser user, @Nonnull Option<ProjectContext> projectContext) {
        return this.hasAdminPermissionForProjectContext(user, projectContext);
    }

    @Override
    public boolean canManageSomeRuleSet(@Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) || this.permissionManager.hasProjects(ProjectPermissions.ADMINISTER_PROJECTS, user);
    }

    @Override
    public boolean hasViewRuleSetPermission(@Nonnull ApplicationUser user, @Nonnull Option<ProjectContext> projectContext) {
        return this.hasAdminPermissionForProjectContext(user, projectContext);
    }

    private boolean hasAdminPermissionForProjectContext(@Nonnull ApplicationUser user, @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"projectContext", projectContext);
        boolean hasGlobalJiraAdmin = this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
        if (hasGlobalJiraAdmin) {
            return true;
        }
        if (projectContext.isDefined() && !((ProjectContext)projectContext.get()).isGlobal()) {
            ProjectContext context = (ProjectContext)projectContext.get();
            for (Project project : context.getProjects()) {
                boolean hasProjectAdmin = this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
                if (hasProjectAdmin) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, Unit> toEither(@Nonnull ApplicationUser user, boolean permissionCheckResult) {
        Assertions.notNull((String)"user", (Object)user);
        if (!permissionCheckResult) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.FORBIDDEN, "sd.automation.no.permission.error", new Object[0]));
        }
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }
}

