/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.module;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.param.WhenHandlerValidationParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.visualiser.param.RuleComponentVisualiserParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionAwarePluginPointFunction;
import com.atlassian.servicedesk.plugins.automation.internal.module.RuleComponentHelper;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerData;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerModuleData;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.WhenHandlerModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.WhenHandlerValidator;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Options;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhenHandlerManagerImpl
implements WhenHandlerManager {
    final PluginAccessor pluginAccessor;

    @Autowired
    public WhenHandlerManagerImpl(@Nonnull PluginAccessor pluginAccessor) {
        Assertions.notNull((String)"pluginAccessor", (Object)pluginAccessor);
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public List<WhenHandlerModuleData> getWhenHandlerModuleDataList() {
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        RetrieveWhenHandlerPluginPointVisitor retrievewhenHandlerPluginPointVisitor = new RetrieveWhenHandlerPluginPointVisitor();
        List optionList = safeAccessor.forType(WhenHandlerModuleDescriptor.class, (PluginPointFunction)retrievewhenHandlerPluginPointVisitor);
        return Lists.newArrayList((Iterable)Options.flatten((Iterable)optionList));
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<? extends ModuleAccessError, WhenHandlerData> getConfiguredWhenHandlerData(final @Nonnull ApplicationUser user, @Nonnull String moduleKey, final @Nonnull ConfigurationData whenConfigurationData) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"moduleKey", (Object)moduleKey);
        Assertions.notNull((String)"configurationData", (Object)whenConfigurationData);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either validatorRetrievalResult = StepsConverters.newerEither((Either)safeAccessor.forKey(moduleKey, WhenHandlerModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<WhenHandlerModuleDescriptor, String, io.atlassian.fugue.Option<WhenHandlerData>>(){

            @Override
            protected io.atlassian.fugue.Option<WhenHandlerData> onModuleShouldDisplay(WhenHandlerModuleDescriptor moduleDescriptor, String module) {
                return io.atlassian.fugue.Option.some((Object)WhenHandlerManagerImpl.this.getWhenHandlerData(user, whenConfigurationData, moduleDescriptor));
            }

            @Override
            protected io.atlassian.fugue.Option<WhenHandlerData> onModuleShouldNotDisplay(WhenHandlerModuleDescriptor moduleDescriptor, String module) {
                return io.atlassian.fugue.Option.none();
            }
        }));
        return RuleComponentHelper.mapToModuleNotFound(validatorRetrievalResult);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<? extends ModuleAccessError, ValidationResult> validateWhenHandler(final @Nonnull ApplicationUser userToValidateWith, final @Nonnull WhenHandlerConfiguration componentConfiguration, final @Nonnull io.atlassian.fugue.Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"userToValidateWith", (Object)userToValidateWith);
        Assertions.notNull((String)"projectContext", projectContext);
        Assertions.notNull((String)"componentConfiguration", (Object)componentConfiguration);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either validatorRetrievalResult = StepsConverters.newerEither((Either)safeAccessor.forKey(componentConfiguration.getModuleKey(), WhenHandlerModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<WhenHandlerModuleDescriptor, String, io.atlassian.fugue.Option<ValidationResult>>(){

            @Override
            protected io.atlassian.fugue.Option<ValidationResult> onModuleShouldDisplay(WhenHandlerModuleDescriptor moduleDescriptor, String module) {
                return io.atlassian.fugue.Option.some((Object)WhenHandlerManagerImpl.this.onWhenHandlerModule(userToValidateWith, componentConfiguration, moduleDescriptor, (io.atlassian.fugue.Option<ProjectContext>)projectContext));
            }

            @Override
            protected io.atlassian.fugue.Option<ValidationResult> onModuleShouldNotDisplay(WhenHandlerModuleDescriptor moduleDescriptor, String module) {
                return io.atlassian.fugue.Option.none();
            }
        }));
        return RuleComponentHelper.mapToModuleNotFound(validatorRetrievalResult);
    }

    private WhenHandlerData getWhenHandlerData(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData, @Nonnull WhenHandlerModuleDescriptor whenHandlerModuleDescriptor) {
        io.atlassian.fugue.Option displayLabel;
        String displayName;
        WhenHandlerModuleData whenHandlerModuleData = this.buildWhenHandlerModuleData(whenHandlerModuleDescriptor);
        io.atlassian.fugue.Option visualiserOption = StepsConverters.newerOption(whenHandlerModuleDescriptor.getVisualiser());
        if (visualiserOption.isDefined()) {
            RuleComponentVisualiserParamImpl ruleComponentVisualiserParam = new RuleComponentVisualiserParamImpl(user, configurationData);
            displayName = (String)Assertions.notNull((String)"visualiser name cannot be null", (Object)((RuleComponentVisualiser)visualiserOption.get()).getName((RuleComponentVisualiser.RuleComponentVisualiserParam)ruleComponentVisualiserParam));
            displayLabel = StepsConverters.newerOption((Option)((Option)Assertions.notNull((String)"visualiser label cannot be null", (Object)((RuleComponentVisualiser)visualiserOption.get()).getLabel((RuleComponentVisualiser.RuleComponentVisualiserParam)ruleComponentVisualiserParam))));
        } else {
            displayName = (String)Assertions.notNull((String)"name cannot be null", (Object)whenHandlerModuleDescriptor.getName());
            displayLabel = io.atlassian.fugue.Option.none();
        }
        WhenHandlerDisplayData whenHandlerDisplayData = new WhenHandlerDisplayData(displayName, (io.atlassian.fugue.Option<String>)displayLabel);
        return new WhenHandlerData(whenHandlerModuleData, whenHandlerDisplayData);
    }

    private WhenHandlerModuleData buildWhenHandlerModuleData(@Nonnull WhenHandlerModuleDescriptor moduleDescriptor) {
        return new WhenHandlerModuleData(moduleDescriptor.getCompleteKey(), moduleDescriptor.getName(), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption(moduleDescriptor.getIconClass()), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption(moduleDescriptor.getWebFormModule()), moduleDescriptor.getProvides(), moduleDescriptor.isUnique());
    }

    private ValidationResult onWhenHandlerModule(@Nonnull ApplicationUser userToValidateWith, @Nonnull WhenHandlerConfiguration componentConfiguration, @Nonnull WhenHandlerModuleDescriptor descriptor, @Nonnull io.atlassian.fugue.Option<ProjectContext> projectContext) {
        io.atlassian.fugue.Option validator = StepsConverters.newerOption(descriptor.getValidator());
        if (validator.isDefined()) {
            WhenHandlerValidationParamImpl whenHandlerValidationParam = new WhenHandlerValidationParamImpl(userToValidateWith, componentConfiguration, (Option<ProjectContext>)StepsConverters.olderOption(projectContext));
            return ((WhenHandlerValidator)validator.get()).validate((WhenHandlerValidator.WhenHandlerValidationParam)whenHandlerValidationParam);
        }
        return ValidationResult.PASSED();
    }

    private class RetrieveWhenHandlerPluginPointVisitor
    extends ConditionAwarePluginPointFunction<WhenHandlerModuleDescriptor, String, io.atlassian.fugue.Option<WhenHandlerModuleData>> {
        private RetrieveWhenHandlerPluginPointVisitor() {
        }

        @Override
        protected io.atlassian.fugue.Option<WhenHandlerModuleData> onModuleShouldDisplay(WhenHandlerModuleDescriptor moduleDescriptor, String module) {
            return io.atlassian.fugue.Option.some((Object)WhenHandlerManagerImpl.this.buildWhenHandlerModuleData(moduleDescriptor));
        }

        @Override
        protected io.atlassian.fugue.Option<WhenHandlerModuleData> onModuleShouldNotDisplay(WhenHandlerModuleDescriptor moduleDescriptor, String module) {
            return io.atlassian.fugue.Option.none();
        }
    }
}

