/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.module;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.param.IfConditionValidationParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.visualiser.param.RuleComponentVisualiserParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionAwarePluginPointFunction;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.param.IfConditionParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionData;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionModuleData;
import com.atlassian.servicedesk.plugins.automation.internal.module.RuleComponentHelper;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.IfConditionModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfConditionValidator;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Options;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IfConditionManagerImpl
implements IfConditionManager {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public IfConditionManagerImpl(@Nonnull PluginAccessor pluginAccessor) {
        Assertions.notNull((String)"pluginAccess", (Object)pluginAccessor);
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public List<IfConditionModuleData> getIfConditionModuleDataList() {
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        RetrieveIfConditionPluginPointVisitor retrieveIfConditionPluginPointVisitor = new RetrieveIfConditionPluginPointVisitor();
        List optionList = safeAccessor.forType(IfConditionModuleDescriptor.class, (PluginPointFunction)retrieveIfConditionPluginPointVisitor);
        return Lists.newArrayList((Iterable)Options.flatten((Iterable)optionList));
    }

    @Override
    public io.atlassian.fugue.Either<? extends ModuleAccessError, IfConditionData> getConfiguredIfConditionData(final @Nonnull ApplicationUser user, @Nonnull String moduleKey, final @Nonnull ConfigurationData ifConfigurationData) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"moduleKey", (Object)moduleKey);
        Assertions.notNull((String)"configurationData", (Object)ifConfigurationData);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either validatorRetrievalResult = StepsConverters.newerEither((Either)safeAccessor.forKey(moduleKey, IfConditionModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<IfConditionModuleDescriptor, IfCondition, io.atlassian.fugue.Option<IfConditionData>>(){

            @Override
            protected io.atlassian.fugue.Option<IfConditionData> onModuleShouldDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition module) {
                return io.atlassian.fugue.Option.some((Object)IfConditionManagerImpl.this.onGetIfConditionData(user, ifConfigurationData, moduleDescriptor));
            }

            @Override
            protected io.atlassian.fugue.Option<IfConditionData> onModuleShouldNotDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition module) {
                return io.atlassian.fugue.Option.none();
            }
        }));
        return RuleComponentHelper.mapToModuleNotFound(validatorRetrievalResult);
    }

    @Override
    public io.atlassian.fugue.Either<? extends ModuleAccessError, ValidationResult> validateIfConditionData(final @Nonnull ApplicationUser userToValidateWith, final @Nonnull IfConditionConfiguration ifConditionConfiguration, final @Nonnull io.atlassian.fugue.Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"userToValidateWith", (Object)userToValidateWith);
        Assertions.notNull((String)"ifConditionConfiguration", (Object)ifConditionConfiguration);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either validatorRetrievalResult = StepsConverters.newerEither((Either)safeAccessor.forKey(ifConditionConfiguration.getModuleKey(), IfConditionModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<IfConditionModuleDescriptor, IfCondition, io.atlassian.fugue.Option<ValidationResult>>(){

            @Override
            protected io.atlassian.fugue.Option<ValidationResult> onModuleShouldDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition module) {
                return io.atlassian.fugue.Option.some((Object)IfConditionManagerImpl.this.onIfConditionModule(userToValidateWith, ifConditionConfiguration, moduleDescriptor, (io.atlassian.fugue.Option<ProjectContext>)projectContext));
            }

            @Override
            protected io.atlassian.fugue.Option<ValidationResult> onModuleShouldNotDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition module) {
                return io.atlassian.fugue.Option.none();
            }
        }));
        return RuleComponentHelper.mapToModuleNotFound(validatorRetrievalResult);
    }

    @Override
    public io.atlassian.fugue.Either<? extends ModuleAccessError, io.atlassian.fugue.Either<IfConditionError, Boolean>> evaluateIfCondition(final @Nonnull ApplicationUser user, final @Nonnull IfConditionConfiguration ifConditionConfiguration, final @Nonnull RuleMessage ruleMessage) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ifConditionConfiguration", (Object)ifConditionConfiguration);
        Assertions.notNull((String)"ruleMessage", (Object)ruleMessage);
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        io.atlassian.fugue.Either evaluationResult = StepsConverters.newerEither((Either)safeAccessor.forKey(ifConditionConfiguration.getModuleKey(), IfConditionModuleDescriptor.class, (PluginPointFunction)new ConditionAwarePluginPointFunction<IfConditionModuleDescriptor, IfCondition, io.atlassian.fugue.Option<io.atlassian.fugue.Either<IfConditionError, Boolean>>>(){

            @Override
            protected io.atlassian.fugue.Option<io.atlassian.fugue.Either<IfConditionError, Boolean>> onModuleShouldDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition ifCondition) {
                IfConditionParamImpl ifConditionParam = new IfConditionParamImpl(user, ifConditionConfiguration, ruleMessage);
                return io.atlassian.fugue.Option.some((Object)ifCondition.matches((IfCondition.IfConditionParam)ifConditionParam)).map(StepsConverters::newerEither);
            }

            @Override
            protected io.atlassian.fugue.Option<io.atlassian.fugue.Either<IfConditionError, Boolean>> onModuleShouldNotDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition module) {
                return io.atlassian.fugue.Option.none();
            }
        }));
        return RuleComponentHelper.mapToModuleNotFound(evaluationResult);
    }

    private IfConditionData onGetIfConditionData(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData, @Nonnull IfConditionModuleDescriptor moduleDescriptor) {
        io.atlassian.fugue.Option displayLabel;
        String displayName;
        IfConditionModuleData ifConditionModuleData = this.buildIfConditionModuleData(moduleDescriptor);
        io.atlassian.fugue.Option visualiserOption = StepsConverters.newerOption(moduleDescriptor.getVisualiser());
        if (visualiserOption.isDefined()) {
            RuleComponentVisualiserParamImpl ruleComponentVisualiserParam = new RuleComponentVisualiserParamImpl(user, configurationData);
            displayName = (String)Assertions.notNull((String)"visualiser name cannot be null", (Object)((RuleComponentVisualiser)visualiserOption.get()).getName((RuleComponentVisualiser.RuleComponentVisualiserParam)ruleComponentVisualiserParam));
            displayLabel = StepsConverters.newerOption((Option)((Option)Assertions.notNull((String)"visualiser label cannot be null", (Object)((RuleComponentVisualiser)visualiserOption.get()).getLabel((RuleComponentVisualiser.RuleComponentVisualiserParam)ruleComponentVisualiserParam))));
        } else {
            displayName = (String)Assertions.notNull((String)"name cannot be null", (Object)moduleDescriptor.getName());
            displayLabel = io.atlassian.fugue.Option.none();
        }
        IfConditionDisplayData ifConditionDisplayData = new IfConditionDisplayData(displayName, (io.atlassian.fugue.Option<String>)displayLabel);
        return new IfConditionData(ifConditionModuleData, ifConditionDisplayData);
    }

    private IfConditionModuleData buildIfConditionModuleData(@Nonnull IfConditionModuleDescriptor moduleDescriptor) {
        return new IfConditionModuleData(moduleDescriptor.getCompleteKey(), moduleDescriptor.getName(), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption(moduleDescriptor.getIconClass()), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption(moduleDescriptor.getWebFormModule()), moduleDescriptor.getRequires());
    }

    private ValidationResult onIfConditionModule(@Nonnull ApplicationUser userToValidateWith, @Nonnull IfConditionConfiguration componentConfiguration, @Nonnull IfConditionModuleDescriptor descriptor, @Nonnull io.atlassian.fugue.Option<ProjectContext> projectContext) {
        io.atlassian.fugue.Option validator = StepsConverters.newerOption(descriptor.getValidator());
        if (validator.isDefined()) {
            IfConditionValidationParamImpl ifConditionValidationParam = new IfConditionValidationParamImpl(userToValidateWith, componentConfiguration, (Option<ProjectContext>)StepsConverters.olderOption(projectContext));
            return ((IfConditionValidator)validator.get()).validate((IfConditionValidator.IfConditionValidationParam)ifConditionValidationParam);
        }
        return ValidationResult.PASSED();
    }

    private class RetrieveIfConditionPluginPointVisitor
    extends ConditionAwarePluginPointFunction<IfConditionModuleDescriptor, IfCondition, io.atlassian.fugue.Option<IfConditionModuleData>> {
        private RetrieveIfConditionPluginPointVisitor() {
        }

        @Override
        protected io.atlassian.fugue.Option<IfConditionModuleData> onModuleShouldDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition module) {
            return io.atlassian.fugue.Option.some((Object)IfConditionManagerImpl.this.buildIfConditionModuleData(moduleDescriptor));
        }

        @Override
        protected io.atlassian.fugue.Option<IfConditionModuleData> onModuleShouldNotDisplay(IfConditionModuleDescriptor moduleDescriptor, IfCondition module) {
            return io.atlassian.fugue.Option.none();
        }
    }
}

