/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.whenhandler.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectDeletedEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectDeletedEventListener.class);
    private final RuleSetManager ruleSetManager;

    @Autowired
    public ProjectDeletedEventListener(RuleSetManager ruleSetManager) {
        this.ruleSetManager = ruleSetManager;
    }

    @EventListener
    public void handleProjectDeletedEvent(ProjectDeletedEvent event) {
        long deletedProjectId = event.getProject().getId();
        List<AnError> errors = this.ruleSetManager.cleanRulesForDeletedProject(deletedProjectId);
        for (AnError e : errors) {
            LOG.warn(String.format("An error occurred while cleaning up automation rules for deleted project with id '%s': %s", deletedProjectId, e.getMessage().getMessage()));
        }
    }
}

