/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.whenhandler.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.engine.RulesEngine;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerService;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.EventWhenHandlerModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.whenhandler.event.AllEventListenerEventWhenHandlerVisitor;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AllEventsListener {
    private final WhenHandlerService whenHandlerService;
    private final RulesEngine rulesEngine;
    private final PluginAccessor pluginAccessor;
    private volatile boolean shouldProcessEvents;

    @Autowired
    public AllEventsListener(@Nonnull RulesEngine rulesEngine, @Nonnull WhenHandlerService whenHandlerService, @Nonnull PluginAccessor pluginAccessor) {
        this.rulesEngine = rulesEngine;
        this.whenHandlerService = whenHandlerService;
        this.pluginAccessor = pluginAccessor;
    }

    @EventListener
    public void onAllEvents(Object event) {
        if (!this.shouldProcessEvents) {
            return;
        }
        SafePluginPointAccess.call(() -> {
            this.invokeHandlers(event);
            return Unit.UNIT;
        });
    }

    public synchronized void disableEventsProcessing(EventPublisher eventPublisher) {
        this.shouldProcessEvents = false;
        eventPublisher.unregister((Object)this);
    }

    public synchronized void enableEventsProcessing(EventPublisher eventPublisher) {
        this.shouldProcessEvents = true;
        eventPublisher.register((Object)this);
    }

    private void invokeHandlers(Object event) {
        AllEventListenerEventWhenHandlerVisitor visitor = new AllEventListenerEventWhenHandlerVisitor(this.whenHandlerService, event, this.pluginAccessor);
        this.visitAll(visitor);
        List<RuleExecutionCommand> commands = visitor.getCommands();
        if (!commands.isEmpty()) {
            this.rulesEngine.enqueue(commands);
        }
    }

    @VisibleForTesting
    void visitAll(AllEventListenerEventWhenHandlerVisitor visitor) {
        SafeAccessViaPluginAccessor safeAccessor = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        safeAccessor.forType(EventWhenHandlerModuleDescriptor.class, (PluginPointVisitor)visitor);
    }
}

