/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.whenhandler.event;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerService;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.EventWhenHandlerModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ModuleAvailabilityChecker;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.WhenHandlerModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AllEventListenerEventWhenHandlerVisitor
implements PluginPointVisitor<EventWhenHandlerModuleDescriptor, EventWhenHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(AllEventListenerEventWhenHandlerVisitor.class);
    private WhenHandlerService whenHandlerService;
    private final Object receivedEvent;
    private List<RuleExecutionCommand> commands;
    private final PluginAccessor pluginAccessor;

    public AllEventListenerEventWhenHandlerVisitor(WhenHandlerService whenHandlerService, Object receivedEvent, PluginAccessor pluginAccessor) {
        this.receivedEvent = receivedEvent;
        this.pluginAccessor = pluginAccessor;
        this.commands = Lists.newArrayList();
        this.whenHandlerService = whenHandlerService;
    }

    public void visit(EventWhenHandlerModuleDescriptor moduleDescriptor, EventWhenHandler eventWhenHandler) {
        String whenHandlerKey = moduleDescriptor.getWhenHandlerCompleteKey();
        String eventWhenHandlerKey = moduleDescriptor.getCompleteKey();
        if (!this.canHandleEvent(eventWhenHandler)) {
            return;
        }
        if (StringUtils.isEmpty((String)whenHandlerKey)) {
            LOG.warn("EventWhenHandler is misconfigured. No when handler module key is defined");
            return;
        }
        if (!this.isWhenHandlerActive(whenHandlerKey)) {
            LOG.debug("EventWhenHandler '{}' is not active.", (Object)whenHandlerKey);
            return;
        }
        List<Either<AnError, WhenHandlerContext>> contextsForWhenHandlerKeyEither = this.fetchWhenHandlerConfiguration(whenHandlerKey);
        if (contextsForWhenHandlerKeyEither.isEmpty()) {
            LOG.debug("No configurations found for {}. Skipping event handler '{}'.", (Object)whenHandlerKey, (Object)eventWhenHandlerKey);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing When Handler for event of class '{}'.", (Object)eventWhenHandler.getEventClass());
            this.logSchedulerState();
        }
        this.executeEventWhenHandler(eventWhenHandler, eventWhenHandlerKey, contextsForWhenHandlerKeyEither);
    }

    public List<RuleExecutionCommand> getCommands() {
        return this.commands;
    }

    private void executeEventWhenHandler(EventWhenHandler eventWhenHandler, String eventWhenHandlerKey, List<Either<AnError, WhenHandlerContext>> contextsForWhenHandlerKeyEither) {
        try {
            ArrayList<WhenHandlerContext> whenHandlerContexts = new ArrayList<WhenHandlerContext>();
            for (Either<AnError, WhenHandlerContext> contextEither : contextsForWhenHandlerKeyEither) {
                if (contextEither.isRight()) {
                    whenHandlerContexts.add((WhenHandlerContext)contextEither.right().get());
                    continue;
                }
                LOG.debug("Failed to retrieve handler context for {}: {}", (Object)eventWhenHandlerKey, (Object)((AnError)contextEither.left().get()).getMessage());
            }
            this.getEventHandlerCommands(eventWhenHandler, whenHandlerContexts).forEach(this.commands::addAll);
        }
        catch (Exception exception) {
            LOG.warn(String.format("Event when handler execution of %s failed", eventWhenHandlerKey), (Throwable)exception);
        }
    }

    private Option<List<RuleExecutionCommand>> getEventHandlerCommands(EventWhenHandler eventWhenHandler, List<WhenHandlerContext> whenHandlerContexts) {
        return Option.option((Object)eventWhenHandler.handleEvent(whenHandlerContexts, this.receivedEvent));
    }

    private List<Either<AnError, WhenHandlerContext>> fetchWhenHandlerConfiguration(String whenHandlerKey) {
        return this.whenHandlerService.getContextsForWhenHandlerKey(whenHandlerKey).stream().map(StepsConverters::newerEither).collect(Collectors.toList());
    }

    private boolean canHandleEvent(EventWhenHandler eventWhenHandler) {
        return eventWhenHandler.getEventClass().isAssignableFrom(this.receivedEvent.getClass());
    }

    private boolean isWhenHandlerActive(String whenHandlerKey) {
        return ModuleAvailabilityChecker.check(whenHandlerKey, WhenHandlerModuleDescriptor.class, this.pluginAccessor);
    }

    private void logSchedulerState() {
        SchedulerService schedulerService = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
        if (schedulerService == null) {
            return;
        }
        Set jobRunners = schedulerService.getJobRunnerKeysForAllScheduledJobs();
        long numJobs = jobRunners.stream().flatMap(jobRunnerKey -> schedulerService.getJobsByJobRunnerKey(jobRunnerKey).stream()).collect(Collectors.toList()).size();
        LOG.debug("Atlassian Scheduler state: {} jobs runners and {} jobs.", (Object)jobRunners.size(), (Object)numJobs);
    }
}

