/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.whenhandler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerService;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.JiraAuthenticationContextCurrentUserProvider;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserContext;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserContextManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.whenhandler.WhenHandlerContextImpl;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WhenHandlerServiceImpl
implements WhenHandlerService {
    private static final Logger log = LoggerFactory.getLogger(WhenHandlerServiceImpl.class);
    private final RuleSetManager ruleSetManager;
    private final RunAsUserContextManager runAsUserContextManager;
    private final JiraAuthenticationContextCurrentUserProvider jiraAuthenticationContextCurrentUserProvider;

    @Autowired
    public WhenHandlerServiceImpl(@Nonnull RuleSetManager ruleSetManager, @Nonnull RunAsUserContextManager runAsUserContextManager, @Nonnull JiraAuthenticationContextCurrentUserProvider jiraAuthenticationContextCurrentUserProvider) {
        this.ruleSetManager = ruleSetManager;
        this.runAsUserContextManager = runAsUserContextManager;
        this.jiraAuthenticationContextCurrentUserProvider = jiraAuthenticationContextCurrentUserProvider;
    }

    @Nonnull
    public List<Either<AnError, WhenHandlerContext>> getContextsForWhenHandlerKey(@Nonnull String whenHandlerModuleKey) {
        Assertions.isTrue((String)"whenHandlerModuleKey is required", (boolean)StringUtils.isNotBlank((String)whenHandlerModuleKey));
        List<RuleSet> activeRuleSets = this.ruleSetManager.getActiveRuleSets();
        ArrayList<io.atlassian.fugue.Either<AnError, WhenHandlerContext>> whenHandlerContexts = new ArrayList<io.atlassian.fugue.Either<AnError, WhenHandlerContext>>();
        for (RuleSet ruleSet : activeRuleSets) {
            for (Rule rule : ruleSet.getRules()) {
                whenHandlerContexts.addAll(this.getRuleContext(whenHandlerModuleKey, ruleSet, rule));
            }
        }
        return whenHandlerContexts.stream().map(StepsConverters::olderEither).collect(Collectors.toList());
    }

    private List<io.atlassian.fugue.Either<AnError, WhenHandlerContext>> getRuleContext(@Nonnull String whenHandlerModuleKey, RuleSet ruleSet, Rule rule) {
        ArrayList<io.atlassian.fugue.Either<AnError, WhenHandlerContext>> whenHandlerContexts = new ArrayList<io.atlassian.fugue.Either<AnError, WhenHandlerContext>>();
        if (rule.isEnabled()) {
            for (WhenHandlerConfiguration whenHandlerConfiguration : rule.getWhen().getWhenHandlerConfigurations()) {
                if (!whenHandlerConfiguration.getModuleKey().equals(whenHandlerModuleKey)) continue;
                whenHandlerContexts.add(this.getContextForRule(rule, ruleSet, whenHandlerConfiguration));
            }
        } else {
            this.logRuleIfApplicable(whenHandlerModuleKey, rule);
        }
        return whenHandlerContexts;
    }

    private void logRuleIfApplicable(@Nonnull String whenHandlerModuleKey, Rule rule) {
        String whenHandlerModuleKeys;
        if (log.isDebugEnabled() && (whenHandlerModuleKeys = StringUtils.join((Collection)rule.getWhen().getWhenHandlerConfigurations().stream().map(WhenHandlerConfiguration::getModuleKey).collect(Collectors.toList()), (String)",")).contains(whenHandlerModuleKey)) {
            log.debug("Rule with id '{}' with '{}' whenHandler is disabled and will not execute", (Object)((RuleImpl)rule).getId(), (Object)whenHandlerModuleKey);
        }
    }

    private io.atlassian.fugue.Either<AnError, WhenHandlerContext> getContextForRule(Rule rule, RuleSet ruleSet, WhenHandlerConfiguration whenHandlerConfiguration) {
        io.atlassian.fugue.Either<AnError, RunAsUserContext> applicableContextForRuleEither = this.runAsUserContextManager.getApplicableContextForRule(ruleSet);
        if (applicableContextForRuleEither.isLeft()) {
            AnError e = (AnError)applicableContextForRuleEither.left().get();
            return this.wrapErrorWithRuleSetDescription(e, ruleSet);
        }
        RunAsUserContext runAsUserContext = (RunAsUserContext)applicableContextForRuleEither.right().get();
        io.atlassian.fugue.Either<AnError, Option<ApplicationUser>> userFromContext = this.runAsUserContextManager.getUserFromContext(runAsUserContext, this.jiraAuthenticationContextCurrentUserProvider);
        if (userFromContext.isLeft()) {
            AnError e = (AnError)userFromContext.left().get();
            return this.wrapErrorWithRuleSetDescription(e, ruleSet);
        }
        Option runAsUser = (Option)userFromContext.right().get();
        WhenHandlerContextImpl whenHandlerContext = new WhenHandlerContextImpl(whenHandlerConfiguration, ruleSet, rule, (ApplicationUser)runAsUser.getOrNull());
        return io.atlassian.fugue.Either.right((Object)whenHandlerContext);
    }

    private <E> io.atlassian.fugue.Either<AnError, E> wrapErrorWithRuleSetDescription(AnError error, RuleSet ruleSet) {
        String msg = String.format("Could not retrieve context for RuleSet '%s' '%s': %s", ruleSet.getId(), ruleSet.getName(), error.getMessage().getMessage());
        return StepsConverters.newerEither((Either)ServiceResult.error((int)error.getHttpStatusCode(), (String)msg));
    }
}

