/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.rule;

import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.InternalRuleReference;
import java.util.Deque;
import java.util.LinkedList;

public class RuleReferenceStack {
    Deque<InternalRuleReference> stack;

    public RuleReferenceStack(InternalRuleReference reference) {
        this(reference, new LinkedList<InternalRuleReference>());
    }

    private RuleReferenceStack(InternalRuleReference ruleReference, Deque<InternalRuleReference> parents) {
        this.stack = new LinkedList<InternalRuleReference>();
        this.stack.add(ruleReference);
        this.stack.addAll(parents);
    }

    public RuleReferenceStack(Deque<InternalRuleReference> stack) {
        this.stack = new LinkedList<InternalRuleReference>(stack);
    }

    public RuleReferenceStack withRuleReference(InternalRuleReference ruleReference) {
        return new RuleReferenceStack(ruleReference, this.stack);
    }

    public InternalRuleReference getCurrentRuleReference() {
        return this.stack.getFirst();
    }

    public Deque<InternalRuleReference> getStack() {
        return this.stack;
    }

    public int getDepth() {
        return this.stack.size();
    }

    public int countOccurrences(InternalRuleReference ruleReference) {
        int count = 0;
        for (InternalRuleReference reference : this.stack) {
            if (!this.match(reference, ruleReference)) continue;
            ++count;
        }
        return count;
    }

    private boolean match(InternalRuleReference a, InternalRuleReference b) {
        return a.getRuleSetId() == b.getRuleSetId() && a.getRuleSetRevisionId() == b.getRuleSetRevisionId() && a.getRuleId() == b.getRuleId();
    }
}

